
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/ssl_config.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class SslConfig extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public boolean revCheckingEnabled;
    public boolean revCheckingRequiredLocalAnchors;
    public boolean sha1LocalAnchorsEnabled;
    public boolean symantecEnforcementDisabled;
    public int versionMin;
    public int versionMax;
    public short[] disabledCipherSuites;
    public String[] clientCertPoolingPolicy;

    private SslConfig(int version) {
        super(STRUCT_SIZE, version);
        this.revCheckingEnabled = (boolean) false;
        this.revCheckingRequiredLocalAnchors = (boolean) false;
        this.sha1LocalAnchorsEnabled = (boolean) false;
        this.symantecEnforcementDisabled = (boolean) false;
        this.versionMin = (int) SslVersion.TLS1;
        this.versionMax = (int) SslVersion.TLS13;
    }

    public SslConfig() {
        this(0);
    }

    public static SslConfig deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static SslConfig deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static SslConfig decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        SslConfig result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new SslConfig(elementsOrVersion);
                {
                    
                result.revCheckingEnabled = decoder0.readBoolean(8, 0);
                }
                {
                    
                result.revCheckingRequiredLocalAnchors = decoder0.readBoolean(8, 1);
                }
                {
                    
                result.sha1LocalAnchorsEnabled = decoder0.readBoolean(8, 2);
                }
                {
                    
                result.symantecEnforcementDisabled = decoder0.readBoolean(8, 3);
                }
                {
                    
                result.versionMin = decoder0.readInt(12);
                    SslVersion.validate(result.versionMin);
                }
                {
                    
                result.versionMax = decoder0.readInt(16);
                    SslVersion.validate(result.versionMax);
                }
                {
                    
                result.disabledCipherSuites = decoder0.readShorts(24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.clientCertPoolingPolicy = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        result.clientCertPoolingPolicy[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.revCheckingEnabled, 8, 0);
        
        encoder0.encode(this.revCheckingRequiredLocalAnchors, 8, 1);
        
        encoder0.encode(this.sha1LocalAnchorsEnabled, 8, 2);
        
        encoder0.encode(this.symantecEnforcementDisabled, 8, 3);
        
        encoder0.encode(this.versionMin, 12);
        
        encoder0.encode(this.versionMax, 16);
        
        encoder0.encode(this.disabledCipherSuites, 24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        if (this.clientCertPoolingPolicy == null) {
            encoder0.encodeNullPointer(32, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.clientCertPoolingPolicy.length, 32, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.clientCertPoolingPolicy.length; ++i0) {
                
                encoder1.encode(this.clientCertPoolingPolicy[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }
}