
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/proxy_config_with_annotation.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ProxyErrorClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ProxyErrorClient, ProxyErrorClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ProxyErrorClient, ProxyErrorClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.ProxyErrorClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ProxyErrorClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public ProxyErrorClient[] buildArray(int size) {
          return new ProxyErrorClient[size];
        }
    };


    private static final int ON_PAC_SCRIPT_ERROR_ORDINAL = 0;

    private static final int ON_REQUEST_MAYBE_FAILED_DUE_TO_PROXY_SETTINGS_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ProxyErrorClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onPacScriptError(
int lineNumber, String details) {

            ProxyErrorClientOnPacScriptErrorParams _message = new ProxyErrorClientOnPacScriptErrorParams();

            _message.lineNumber = lineNumber;

            _message.details = details;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_PAC_SCRIPT_ERROR_ORDINAL)));

        }


        @Override
        public void onRequestMaybeFailedDueToProxySettings(
int netError) {

            ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams _message = new ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams();

            _message.netError = netError;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_REQUEST_MAYBE_FAILED_DUE_TO_PROXY_SETTINGS_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ProxyErrorClient> {

        Stub(com.vccorp.mojo.system.Core core, ProxyErrorClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ProxyErrorClient_Internal.MANAGER, messageWithHeader);





                    case ON_PAC_SCRIPT_ERROR_ORDINAL: {

                        ProxyErrorClientOnPacScriptErrorParams data =
                                ProxyErrorClientOnPacScriptErrorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onPacScriptError(data.lineNumber, data.details);
                        return true;
                    }





                    case ON_REQUEST_MAYBE_FAILED_DUE_TO_PROXY_SETTINGS_ORDINAL: {

                        ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams data =
                                ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onRequestMaybeFailedDueToProxySettings(data.netError);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ProxyErrorClient_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ProxyErrorClientOnPacScriptErrorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int lineNumber;
        public String details;

        private ProxyErrorClientOnPacScriptErrorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyErrorClientOnPacScriptErrorParams() {
            this(0);
        }

        public static ProxyErrorClientOnPacScriptErrorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyErrorClientOnPacScriptErrorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyErrorClientOnPacScriptErrorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyErrorClientOnPacScriptErrorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyErrorClientOnPacScriptErrorParams(elementsOrVersion);
                    {
                        
                    result.lineNumber = decoder0.readInt(8);
                    }
                    {
                        
                    result.details = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.lineNumber, 8);
            
            encoder0.encode(this.details, 16, false);
        }
    }



    
    static final class ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int netError;

        private ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams() {
            this(0);
        }

        public static ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyErrorClientOnRequestMaybeFailedDueToProxySettingsParams(elementsOrVersion);
                    {
                        
                    result.netError = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.netError, 8);
        }
    }



}
