
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service_test.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class NetworkServiceTest_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<NetworkServiceTest, NetworkServiceTest.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<NetworkServiceTest, NetworkServiceTest.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.NetworkServiceTest";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, NetworkServiceTest impl) {
            return new Stub(core, impl);
        }

        @Override
        public NetworkServiceTest[] buildArray(int size) {
          return new NetworkServiceTest[size];
        }
    };


    private static final int ADD_RULES_ORDINAL = 0;

    private static final int SIMULATE_NETWORK_CHANGE_ORDINAL = 1;

    private static final int SIMULATE_NETWORK_QUALITY_CHANGE_ORDINAL = 2;

    private static final int SIMULATE_CRASH_ORDINAL = 3;

    private static final int MOCK_CERT_VERIFIER_SET_DEFAULT_RESULT_ORDINAL = 4;

    private static final int MOCK_CERT_VERIFIER_ADD_RESULT_FOR_CERT_AND_HOST_ORDINAL = 5;

    private static final int SET_SHOULD_REQUIRE_CT_ORDINAL = 6;

    private static final int SET_TRANSPORT_SECURITY_STATE_SOURCE_ORDINAL = 7;

    private static final int CRASH_ON_RESOLVE_HOST_ORDINAL = 8;

    private static final int CRASH_ON_GET_COOKIE_LIST_ORDINAL = 9;

    private static final int GET_LATEST_MEMORY_PRESSURE_LEVEL_ORDINAL = 10;

    private static final int GET_ENVIRONMENT_VARIABLE_VALUE_ORDINAL = 11;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements NetworkServiceTest.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void addRules(
Rule[] rules, 
AddRulesResponse callback) {

            NetworkServiceTestAddRulesParams _message = new NetworkServiceTestAddRulesParams();

            _message.rules = rules;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ADD_RULES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestAddRulesResponseParamsForwardToCallback(callback));

        }


        @Override
        public void simulateNetworkChange(
int type, 
SimulateNetworkChangeResponse callback) {

            NetworkServiceTestSimulateNetworkChangeParams _message = new NetworkServiceTestSimulateNetworkChangeParams();

            _message.type = type;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SIMULATE_NETWORK_CHANGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestSimulateNetworkChangeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void simulateNetworkQualityChange(
int type, 
SimulateNetworkQualityChangeResponse callback) {

            NetworkServiceTestSimulateNetworkQualityChangeParams _message = new NetworkServiceTestSimulateNetworkQualityChangeParams();

            _message.type = type;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SIMULATE_NETWORK_QUALITY_CHANGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestSimulateNetworkQualityChangeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void simulateCrash(
) {

            NetworkServiceTestSimulateCrashParams _message = new NetworkServiceTestSimulateCrashParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SIMULATE_CRASH_ORDINAL)));

        }


        @Override
        public void mockCertVerifierSetDefaultResult(
int defaultResult, 
MockCertVerifierSetDefaultResultResponse callback) {

            NetworkServiceTestMockCertVerifierSetDefaultResultParams _message = new NetworkServiceTestMockCertVerifierSetDefaultResultParams();

            _message.defaultResult = defaultResult;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    MOCK_CERT_VERIFIER_SET_DEFAULT_RESULT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestMockCertVerifierSetDefaultResultResponseParamsForwardToCallback(callback));

        }


        @Override
        public void mockCertVerifierAddResultForCertAndHost(
X509Certificate cert, String hostPattern, CertVerifyResult verifyResult, int rv, 
MockCertVerifierAddResultForCertAndHostResponse callback) {

            NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams _message = new NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams();

            _message.cert = cert;

            _message.hostPattern = hostPattern;

            _message.verifyResult = verifyResult;

            _message.rv = rv;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    MOCK_CERT_VERIFIER_ADD_RESULT_FOR_CERT_AND_HOST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setShouldRequireCt(
int required, 
SetShouldRequireCtResponse callback) {

            NetworkServiceTestSetShouldRequireCtParams _message = new NetworkServiceTestSetShouldRequireCtParams();

            _message.required = required;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_SHOULD_REQUIRE_CT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestSetShouldRequireCtResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setTransportSecurityStateSource(
short reportingPort, 
SetTransportSecurityStateSourceResponse callback) {

            NetworkServiceTestSetTransportSecurityStateSourceParams _message = new NetworkServiceTestSetTransportSecurityStateSourceParams();

            _message.reportingPort = reportingPort;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_TRANSPORT_SECURITY_STATE_SOURCE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestSetTransportSecurityStateSourceResponseParamsForwardToCallback(callback));

        }


        @Override
        public void crashOnResolveHost(
String host) {

            NetworkServiceTestCrashOnResolveHostParams _message = new NetworkServiceTestCrashOnResolveHostParams();

            _message.host = host;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CRASH_ON_RESOLVE_HOST_ORDINAL)));

        }


        @Override
        public void crashOnGetCookieList(
) {

            NetworkServiceTestCrashOnGetCookieListParams _message = new NetworkServiceTestCrashOnGetCookieListParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CRASH_ON_GET_COOKIE_LIST_ORDINAL)));

        }


        @Override
        public void getLatestMemoryPressureLevel(

GetLatestMemoryPressureLevelResponse callback) {

            NetworkServiceTestGetLatestMemoryPressureLevelParams _message = new NetworkServiceTestGetLatestMemoryPressureLevelParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_LATEST_MEMORY_PRESSURE_LEVEL_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestGetLatestMemoryPressureLevelResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getEnvironmentVariableValue(
String name, 
GetEnvironmentVariableValueResponse callback) {

            NetworkServiceTestGetEnvironmentVariableValueParams _message = new NetworkServiceTestGetEnvironmentVariableValueParams();

            _message.name = name;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_ENVIRONMENT_VARIABLE_VALUE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceTestGetEnvironmentVariableValueResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<NetworkServiceTest> {

        Stub(com.vccorp.mojo.system.Core core, NetworkServiceTest impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NetworkServiceTest_Internal.MANAGER, messageWithHeader);











                    case SIMULATE_CRASH_ORDINAL: {

                        NetworkServiceTestSimulateCrashParams.deserialize(messageWithHeader.getPayload());

                        getImpl().simulateCrash();
                        return true;
                    }













                    case CRASH_ON_RESOLVE_HOST_ORDINAL: {

                        NetworkServiceTestCrashOnResolveHostParams data =
                                NetworkServiceTestCrashOnResolveHostParams.deserialize(messageWithHeader.getPayload());

                        getImpl().crashOnResolveHost(data.host);
                        return true;
                    }





                    case CRASH_ON_GET_COOKIE_LIST_ORDINAL: {

                        NetworkServiceTestCrashOnGetCookieListParams.deserialize(messageWithHeader.getPayload());

                        getImpl().crashOnGetCookieList();
                        return true;
                    }






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NetworkServiceTest_Internal.MANAGER, messageWithHeader, receiver);







                    case ADD_RULES_ORDINAL: {

                        NetworkServiceTestAddRulesParams data =
                                NetworkServiceTestAddRulesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addRules(data.rules, new NetworkServiceTestAddRulesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SIMULATE_NETWORK_CHANGE_ORDINAL: {

                        NetworkServiceTestSimulateNetworkChangeParams data =
                                NetworkServiceTestSimulateNetworkChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().simulateNetworkChange(data.type, new NetworkServiceTestSimulateNetworkChangeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SIMULATE_NETWORK_QUALITY_CHANGE_ORDINAL: {

                        NetworkServiceTestSimulateNetworkQualityChangeParams data =
                                NetworkServiceTestSimulateNetworkQualityChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().simulateNetworkQualityChange(data.type, new NetworkServiceTestSimulateNetworkQualityChangeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }









                    case MOCK_CERT_VERIFIER_SET_DEFAULT_RESULT_ORDINAL: {

                        NetworkServiceTestMockCertVerifierSetDefaultResultParams data =
                                NetworkServiceTestMockCertVerifierSetDefaultResultParams.deserialize(messageWithHeader.getPayload());

                        getImpl().mockCertVerifierSetDefaultResult(data.defaultResult, new NetworkServiceTestMockCertVerifierSetDefaultResultResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case MOCK_CERT_VERIFIER_ADD_RESULT_FOR_CERT_AND_HOST_ORDINAL: {

                        NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams data =
                                NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams.deserialize(messageWithHeader.getPayload());

                        getImpl().mockCertVerifierAddResultForCertAndHost(data.cert, data.hostPattern, data.verifyResult, data.rv, new NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_SHOULD_REQUIRE_CT_ORDINAL: {

                        NetworkServiceTestSetShouldRequireCtParams data =
                                NetworkServiceTestSetShouldRequireCtParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setShouldRequireCt(data.required, new NetworkServiceTestSetShouldRequireCtResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_TRANSPORT_SECURITY_STATE_SOURCE_ORDINAL: {

                        NetworkServiceTestSetTransportSecurityStateSourceParams data =
                                NetworkServiceTestSetTransportSecurityStateSourceParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setTransportSecurityStateSource(data.reportingPort, new NetworkServiceTestSetTransportSecurityStateSourceResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }











                    case GET_LATEST_MEMORY_PRESSURE_LEVEL_ORDINAL: {

                        NetworkServiceTestGetLatestMemoryPressureLevelParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getLatestMemoryPressureLevel(new NetworkServiceTestGetLatestMemoryPressureLevelResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_ENVIRONMENT_VARIABLE_VALUE_ORDINAL: {

                        NetworkServiceTestGetEnvironmentVariableValueParams data =
                                NetworkServiceTestGetEnvironmentVariableValueParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getEnvironmentVariableValue(data.name, new NetworkServiceTestGetEnvironmentVariableValueResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class NetworkServiceTestAddRulesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public Rule[] rules;

        private NetworkServiceTestAddRulesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestAddRulesParams() {
            this(0);
        }

        public static NetworkServiceTestAddRulesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestAddRulesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestAddRulesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestAddRulesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestAddRulesParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.rules = new Rule[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.rules[i1] = Rule.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.rules == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.rules.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.rules.length; ++i0) {
                    
                    encoder1.encode(this.rules[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class NetworkServiceTestAddRulesResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestAddRulesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestAddRulesResponseParams() {
            this(0);
        }

        public static NetworkServiceTestAddRulesResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestAddRulesResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestAddRulesResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestAddRulesResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestAddRulesResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceTestAddRulesResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.AddRulesResponse mCallback;

        NetworkServiceTestAddRulesResponseParamsForwardToCallback(NetworkServiceTest.AddRulesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ADD_RULES_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestAddRulesResponseParamsProxyToResponder implements NetworkServiceTest.AddRulesResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestAddRulesResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceTestAddRulesResponseParams _response = new NetworkServiceTestAddRulesResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ADD_RULES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceTestSimulateNetworkChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int type;

        private NetworkServiceTestSimulateNetworkChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSimulateNetworkChangeParams() {
            this(0);
        }

        public static NetworkServiceTestSimulateNetworkChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSimulateNetworkChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSimulateNetworkChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSimulateNetworkChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSimulateNetworkChangeParams(elementsOrVersion);
                    {
                        
                    result.type = decoder0.readInt(8);
                        ConnectionType.validate(result.type);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.type, 8);
        }
    }



    
    static final class NetworkServiceTestSimulateNetworkChangeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestSimulateNetworkChangeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSimulateNetworkChangeResponseParams() {
            this(0);
        }

        public static NetworkServiceTestSimulateNetworkChangeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSimulateNetworkChangeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSimulateNetworkChangeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSimulateNetworkChangeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSimulateNetworkChangeResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceTestSimulateNetworkChangeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.SimulateNetworkChangeResponse mCallback;

        NetworkServiceTestSimulateNetworkChangeResponseParamsForwardToCallback(NetworkServiceTest.SimulateNetworkChangeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SIMULATE_NETWORK_CHANGE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestSimulateNetworkChangeResponseParamsProxyToResponder implements NetworkServiceTest.SimulateNetworkChangeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestSimulateNetworkChangeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceTestSimulateNetworkChangeResponseParams _response = new NetworkServiceTestSimulateNetworkChangeResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SIMULATE_NETWORK_CHANGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceTestSimulateNetworkQualityChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int type;

        private NetworkServiceTestSimulateNetworkQualityChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSimulateNetworkQualityChangeParams() {
            this(0);
        }

        public static NetworkServiceTestSimulateNetworkQualityChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSimulateNetworkQualityChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSimulateNetworkQualityChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSimulateNetworkQualityChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSimulateNetworkQualityChangeParams(elementsOrVersion);
                    {
                        
                    result.type = decoder0.readInt(8);
                        EffectiveConnectionType.validate(result.type);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.type, 8);
        }
    }



    
    static final class NetworkServiceTestSimulateNetworkQualityChangeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestSimulateNetworkQualityChangeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSimulateNetworkQualityChangeResponseParams() {
            this(0);
        }

        public static NetworkServiceTestSimulateNetworkQualityChangeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSimulateNetworkQualityChangeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSimulateNetworkQualityChangeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSimulateNetworkQualityChangeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSimulateNetworkQualityChangeResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceTestSimulateNetworkQualityChangeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.SimulateNetworkQualityChangeResponse mCallback;

        NetworkServiceTestSimulateNetworkQualityChangeResponseParamsForwardToCallback(NetworkServiceTest.SimulateNetworkQualityChangeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SIMULATE_NETWORK_QUALITY_CHANGE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestSimulateNetworkQualityChangeResponseParamsProxyToResponder implements NetworkServiceTest.SimulateNetworkQualityChangeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestSimulateNetworkQualityChangeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceTestSimulateNetworkQualityChangeResponseParams _response = new NetworkServiceTestSimulateNetworkQualityChangeResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SIMULATE_NETWORK_QUALITY_CHANGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceTestSimulateCrashParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestSimulateCrashParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSimulateCrashParams() {
            this(0);
        }

        public static NetworkServiceTestSimulateCrashParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSimulateCrashParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSimulateCrashParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSimulateCrashParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSimulateCrashParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkServiceTestMockCertVerifierSetDefaultResultParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int defaultResult;

        private NetworkServiceTestMockCertVerifierSetDefaultResultParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestMockCertVerifierSetDefaultResultParams() {
            this(0);
        }

        public static NetworkServiceTestMockCertVerifierSetDefaultResultParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestMockCertVerifierSetDefaultResultParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestMockCertVerifierSetDefaultResultParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestMockCertVerifierSetDefaultResultParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestMockCertVerifierSetDefaultResultParams(elementsOrVersion);
                    {
                        
                    result.defaultResult = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.defaultResult, 8);
        }
    }



    
    static final class NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams() {
            this(0);
        }

        public static NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceTestMockCertVerifierSetDefaultResultResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.MockCertVerifierSetDefaultResultResponse mCallback;

        NetworkServiceTestMockCertVerifierSetDefaultResultResponseParamsForwardToCallback(NetworkServiceTest.MockCertVerifierSetDefaultResultResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(MOCK_CERT_VERIFIER_SET_DEFAULT_RESULT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestMockCertVerifierSetDefaultResultResponseParamsProxyToResponder implements NetworkServiceTest.MockCertVerifierSetDefaultResultResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestMockCertVerifierSetDefaultResultResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams _response = new NetworkServiceTestMockCertVerifierSetDefaultResultResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    MOCK_CERT_VERIFIER_SET_DEFAULT_RESULT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public X509Certificate cert;
        public String hostPattern;
        public CertVerifyResult verifyResult;
        public int rv;

        private NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams() {
            this(0);
        }

        public static NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestMockCertVerifierAddResultForCertAndHostParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.cert = X509Certificate.decode(decoder1);
                    }
                    {
                        
                    result.hostPattern = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.verifyResult = CertVerifyResult.decode(decoder1);
                    }
                    {
                        
                    result.rv = decoder0.readInt(32);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cert, 8, false);
            
            encoder0.encode(this.hostPattern, 16, false);
            
            encoder0.encode(this.verifyResult, 24, false);
            
            encoder0.encode(this.rv, 32);
        }
    }



    
    static final class NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams() {
            this(0);
        }

        public static NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.MockCertVerifierAddResultForCertAndHostResponse mCallback;

        NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParamsForwardToCallback(NetworkServiceTest.MockCertVerifierAddResultForCertAndHostResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(MOCK_CERT_VERIFIER_ADD_RESULT_FOR_CERT_AND_HOST_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParamsProxyToResponder implements NetworkServiceTest.MockCertVerifierAddResultForCertAndHostResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams _response = new NetworkServiceTestMockCertVerifierAddResultForCertAndHostResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    MOCK_CERT_VERIFIER_ADD_RESULT_FOR_CERT_AND_HOST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceTestSetShouldRequireCtParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int required;

        private NetworkServiceTestSetShouldRequireCtParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSetShouldRequireCtParams() {
            this(0);
        }

        public static NetworkServiceTestSetShouldRequireCtParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSetShouldRequireCtParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSetShouldRequireCtParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSetShouldRequireCtParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSetShouldRequireCtParams(elementsOrVersion);
                    {
                        
                    result.required = decoder0.readInt(8);
                        NetworkServiceTest.ShouldRequireCt.validate(result.required);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.required, 8);
        }
    }



    
    static final class NetworkServiceTestSetShouldRequireCtResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestSetShouldRequireCtResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSetShouldRequireCtResponseParams() {
            this(0);
        }

        public static NetworkServiceTestSetShouldRequireCtResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSetShouldRequireCtResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSetShouldRequireCtResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSetShouldRequireCtResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSetShouldRequireCtResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceTestSetShouldRequireCtResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.SetShouldRequireCtResponse mCallback;

        NetworkServiceTestSetShouldRequireCtResponseParamsForwardToCallback(NetworkServiceTest.SetShouldRequireCtResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_SHOULD_REQUIRE_CT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestSetShouldRequireCtResponseParamsProxyToResponder implements NetworkServiceTest.SetShouldRequireCtResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestSetShouldRequireCtResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceTestSetShouldRequireCtResponseParams _response = new NetworkServiceTestSetShouldRequireCtResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_SHOULD_REQUIRE_CT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceTestSetTransportSecurityStateSourceParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public short reportingPort;

        private NetworkServiceTestSetTransportSecurityStateSourceParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSetTransportSecurityStateSourceParams() {
            this(0);
        }

        public static NetworkServiceTestSetTransportSecurityStateSourceParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSetTransportSecurityStateSourceParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSetTransportSecurityStateSourceParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSetTransportSecurityStateSourceParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSetTransportSecurityStateSourceParams(elementsOrVersion);
                    {
                        
                    result.reportingPort = decoder0.readShort(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.reportingPort, 8);
        }
    }



    
    static final class NetworkServiceTestSetTransportSecurityStateSourceResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestSetTransportSecurityStateSourceResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestSetTransportSecurityStateSourceResponseParams() {
            this(0);
        }

        public static NetworkServiceTestSetTransportSecurityStateSourceResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestSetTransportSecurityStateSourceResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestSetTransportSecurityStateSourceResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestSetTransportSecurityStateSourceResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestSetTransportSecurityStateSourceResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkServiceTestSetTransportSecurityStateSourceResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.SetTransportSecurityStateSourceResponse mCallback;

        NetworkServiceTestSetTransportSecurityStateSourceResponseParamsForwardToCallback(NetworkServiceTest.SetTransportSecurityStateSourceResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_TRANSPORT_SECURITY_STATE_SOURCE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestSetTransportSecurityStateSourceResponseParamsProxyToResponder implements NetworkServiceTest.SetTransportSecurityStateSourceResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestSetTransportSecurityStateSourceResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkServiceTestSetTransportSecurityStateSourceResponseParams _response = new NetworkServiceTestSetTransportSecurityStateSourceResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_TRANSPORT_SECURITY_STATE_SOURCE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceTestCrashOnResolveHostParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String host;

        private NetworkServiceTestCrashOnResolveHostParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestCrashOnResolveHostParams() {
            this(0);
        }

        public static NetworkServiceTestCrashOnResolveHostParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestCrashOnResolveHostParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestCrashOnResolveHostParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestCrashOnResolveHostParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestCrashOnResolveHostParams(elementsOrVersion);
                    {
                        
                    result.host = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.host, 8, false);
        }
    }



    
    static final class NetworkServiceTestCrashOnGetCookieListParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestCrashOnGetCookieListParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestCrashOnGetCookieListParams() {
            this(0);
        }

        public static NetworkServiceTestCrashOnGetCookieListParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestCrashOnGetCookieListParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestCrashOnGetCookieListParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestCrashOnGetCookieListParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestCrashOnGetCookieListParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkServiceTestGetLatestMemoryPressureLevelParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceTestGetLatestMemoryPressureLevelParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestGetLatestMemoryPressureLevelParams() {
            this(0);
        }

        public static NetworkServiceTestGetLatestMemoryPressureLevelParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestGetLatestMemoryPressureLevelParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestGetLatestMemoryPressureLevelParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestGetLatestMemoryPressureLevelParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestGetLatestMemoryPressureLevelParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkServiceTestGetLatestMemoryPressureLevelResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int memoryPressureLevel;

        private NetworkServiceTestGetLatestMemoryPressureLevelResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestGetLatestMemoryPressureLevelResponseParams() {
            this(0);
        }

        public static NetworkServiceTestGetLatestMemoryPressureLevelResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestGetLatestMemoryPressureLevelResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestGetLatestMemoryPressureLevelResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestGetLatestMemoryPressureLevelResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestGetLatestMemoryPressureLevelResponseParams(elementsOrVersion);
                    {
                        
                    result.memoryPressureLevel = decoder0.readInt(8);
                        com.vccorp.mojo_base.mojom.MemoryPressureLevel.validate(result.memoryPressureLevel);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.memoryPressureLevel, 8);
        }
    }

    static class NetworkServiceTestGetLatestMemoryPressureLevelResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.GetLatestMemoryPressureLevelResponse mCallback;

        NetworkServiceTestGetLatestMemoryPressureLevelResponseParamsForwardToCallback(NetworkServiceTest.GetLatestMemoryPressureLevelResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_LATEST_MEMORY_PRESSURE_LEVEL_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkServiceTestGetLatestMemoryPressureLevelResponseParams response = NetworkServiceTestGetLatestMemoryPressureLevelResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.memoryPressureLevel);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestGetLatestMemoryPressureLevelResponseParamsProxyToResponder implements NetworkServiceTest.GetLatestMemoryPressureLevelResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestGetLatestMemoryPressureLevelResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer memoryPressureLevel) {
            NetworkServiceTestGetLatestMemoryPressureLevelResponseParams _response = new NetworkServiceTestGetLatestMemoryPressureLevelResponseParams();

            _response.memoryPressureLevel = memoryPressureLevel;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_LATEST_MEMORY_PRESSURE_LEVEL_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceTestGetEnvironmentVariableValueParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String name;

        private NetworkServiceTestGetEnvironmentVariableValueParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestGetEnvironmentVariableValueParams() {
            this(0);
        }

        public static NetworkServiceTestGetEnvironmentVariableValueParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestGetEnvironmentVariableValueParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestGetEnvironmentVariableValueParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestGetEnvironmentVariableValueParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestGetEnvironmentVariableValueParams(elementsOrVersion);
                    {
                        
                    result.name = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.name, 8, false);
        }
    }



    
    static final class NetworkServiceTestGetEnvironmentVariableValueResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String value;

        private NetworkServiceTestGetEnvironmentVariableValueResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceTestGetEnvironmentVariableValueResponseParams() {
            this(0);
        }

        public static NetworkServiceTestGetEnvironmentVariableValueResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceTestGetEnvironmentVariableValueResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceTestGetEnvironmentVariableValueResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceTestGetEnvironmentVariableValueResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceTestGetEnvironmentVariableValueResponseParams(elementsOrVersion);
                    {
                        
                    result.value = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.value, 8, false);
        }
    }

    static class NetworkServiceTestGetEnvironmentVariableValueResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkServiceTest.GetEnvironmentVariableValueResponse mCallback;

        NetworkServiceTestGetEnvironmentVariableValueResponseParamsForwardToCallback(NetworkServiceTest.GetEnvironmentVariableValueResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_ENVIRONMENT_VARIABLE_VALUE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkServiceTestGetEnvironmentVariableValueResponseParams response = NetworkServiceTestGetEnvironmentVariableValueResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.value);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceTestGetEnvironmentVariableValueResponseParamsProxyToResponder implements NetworkServiceTest.GetEnvironmentVariableValueResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceTestGetEnvironmentVariableValueResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(String value) {
            NetworkServiceTestGetEnvironmentVariableValueResponseParams _response = new NetworkServiceTestGetEnvironmentVariableValueResponseParams();

            _response.value = value;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_ENVIRONMENT_VARIABLE_VALUE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
