
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/host_resolver.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MdnsListenClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MdnsListenClient, MdnsListenClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MdnsListenClient, MdnsListenClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.MdnsListenClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MdnsListenClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public MdnsListenClient[] buildArray(int size) {
          return new MdnsListenClient[size];
        }
    };


    private static final int ON_ADDRESS_RESULT_ORDINAL = 0;

    private static final int ON_TEXT_RESULT_ORDINAL = 1;

    private static final int ON_HOSTNAME_RESULT_ORDINAL = 2;

    private static final int ON_UNHANDLED_RESULT_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MdnsListenClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onAddressResult(
int updateType, int queryType, IpEndPoint endpoint) {

            MdnsListenClientOnAddressResultParams _message = new MdnsListenClientOnAddressResultParams();

            _message.updateType = updateType;

            _message.queryType = queryType;

            _message.endpoint = endpoint;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ADDRESS_RESULT_ORDINAL)));

        }


        @Override
        public void onTextResult(
int updateType, int queryType, String[] textRecords) {

            MdnsListenClientOnTextResultParams _message = new MdnsListenClientOnTextResultParams();

            _message.updateType = updateType;

            _message.queryType = queryType;

            _message.textRecords = textRecords;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_TEXT_RESULT_ORDINAL)));

        }


        @Override
        public void onHostnameResult(
int updateType, int queryType, HostPortPair host) {

            MdnsListenClientOnHostnameResultParams _message = new MdnsListenClientOnHostnameResultParams();

            _message.updateType = updateType;

            _message.queryType = queryType;

            _message.host = host;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_HOSTNAME_RESULT_ORDINAL)));

        }


        @Override
        public void onUnhandledResult(
int updateType, int queryType) {

            MdnsListenClientOnUnhandledResultParams _message = new MdnsListenClientOnUnhandledResultParams();

            _message.updateType = updateType;

            _message.queryType = queryType;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_UNHANDLED_RESULT_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MdnsListenClient> {

        Stub(com.vccorp.mojo.system.Core core, MdnsListenClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MdnsListenClient_Internal.MANAGER, messageWithHeader);





                    case ON_ADDRESS_RESULT_ORDINAL: {

                        MdnsListenClientOnAddressResultParams data =
                                MdnsListenClientOnAddressResultParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onAddressResult(data.updateType, data.queryType, data.endpoint);
                        return true;
                    }





                    case ON_TEXT_RESULT_ORDINAL: {

                        MdnsListenClientOnTextResultParams data =
                                MdnsListenClientOnTextResultParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onTextResult(data.updateType, data.queryType, data.textRecords);
                        return true;
                    }





                    case ON_HOSTNAME_RESULT_ORDINAL: {

                        MdnsListenClientOnHostnameResultParams data =
                                MdnsListenClientOnHostnameResultParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onHostnameResult(data.updateType, data.queryType, data.host);
                        return true;
                    }





                    case ON_UNHANDLED_RESULT_ORDINAL: {

                        MdnsListenClientOnUnhandledResultParams data =
                                MdnsListenClientOnUnhandledResultParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onUnhandledResult(data.updateType, data.queryType);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MdnsListenClient_Internal.MANAGER, messageWithHeader, receiver);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MdnsListenClientOnAddressResultParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int updateType;
        public int queryType;
        public IpEndPoint endpoint;

        private MdnsListenClientOnAddressResultParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MdnsListenClientOnAddressResultParams() {
            this(0);
        }

        public static MdnsListenClientOnAddressResultParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MdnsListenClientOnAddressResultParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MdnsListenClientOnAddressResultParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MdnsListenClientOnAddressResultParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MdnsListenClientOnAddressResultParams(elementsOrVersion);
                    {
                        
                    result.updateType = decoder0.readInt(8);
                        MdnsListenClient.UpdateType.validate(result.updateType);
                    }
                    {
                        
                    result.queryType = decoder0.readInt(12);
                        DnsQueryType.validate(result.queryType);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.endpoint = IpEndPoint.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.updateType, 8);
            
            encoder0.encode(this.queryType, 12);
            
            encoder0.encode(this.endpoint, 16, false);
        }
    }



    
    static final class MdnsListenClientOnTextResultParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int updateType;
        public int queryType;
        public String[] textRecords;

        private MdnsListenClientOnTextResultParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MdnsListenClientOnTextResultParams() {
            this(0);
        }

        public static MdnsListenClientOnTextResultParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MdnsListenClientOnTextResultParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MdnsListenClientOnTextResultParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MdnsListenClientOnTextResultParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MdnsListenClientOnTextResultParams(elementsOrVersion);
                    {
                        
                    result.updateType = decoder0.readInt(8);
                        MdnsListenClient.UpdateType.validate(result.updateType);
                    }
                    {
                        
                    result.queryType = decoder0.readInt(12);
                        DnsQueryType.validate(result.queryType);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.textRecords = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.textRecords[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.updateType, 8);
            
            encoder0.encode(this.queryType, 12);
            
            if (this.textRecords == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.textRecords.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.textRecords.length; ++i0) {
                    
                    encoder1.encode(this.textRecords[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class MdnsListenClientOnHostnameResultParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int updateType;
        public int queryType;
        public HostPortPair host;

        private MdnsListenClientOnHostnameResultParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MdnsListenClientOnHostnameResultParams() {
            this(0);
        }

        public static MdnsListenClientOnHostnameResultParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MdnsListenClientOnHostnameResultParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MdnsListenClientOnHostnameResultParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MdnsListenClientOnHostnameResultParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MdnsListenClientOnHostnameResultParams(elementsOrVersion);
                    {
                        
                    result.updateType = decoder0.readInt(8);
                        MdnsListenClient.UpdateType.validate(result.updateType);
                    }
                    {
                        
                    result.queryType = decoder0.readInt(12);
                        DnsQueryType.validate(result.queryType);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.host = HostPortPair.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.updateType, 8);
            
            encoder0.encode(this.queryType, 12);
            
            encoder0.encode(this.host, 16, false);
        }
    }



    
    static final class MdnsListenClientOnUnhandledResultParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int updateType;
        public int queryType;

        private MdnsListenClientOnUnhandledResultParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MdnsListenClientOnUnhandledResultParams() {
            this(0);
        }

        public static MdnsListenClientOnUnhandledResultParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MdnsListenClientOnUnhandledResultParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MdnsListenClientOnUnhandledResultParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MdnsListenClientOnUnhandledResultParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MdnsListenClientOnUnhandledResultParams(elementsOrVersion);
                    {
                        
                    result.updateType = decoder0.readInt(8);
                        MdnsListenClient.UpdateType.validate(result.updateType);
                    }
                    {
                        
                    result.queryType = decoder0.readInt(12);
                        DnsQueryType.validate(result.queryType);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.updateType, 8);
            
            encoder0.encode(this.queryType, 12);
        }
    }



}
