
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/public/mojom/base/application_state.mojom
//

package com.vccorp.mojo_base.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ApplicationState {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int UNKNOWN = 0;
    public static final int HAS_RUNNING_ACTIVITIES = 1; // UNKNOWN + 1
    public static final int HAS_PAUSED_ACTIVITIES = 2; // HAS_RUNNING_ACTIVITIES + 1
    public static final int HAS_STOPPED_ACTIVITIES = 3; // HAS_PAUSED_ACTIVITIES + 1
    public static final int HAS_DESTROYED_ACTIVITIES = 4; // HAS_STOPPED_ACTIVITIES + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 4;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ApplicationState() {}
}