
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/media_session/public/mojom/media_session.mojom
//

package com.vccorp.media_session.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MediaSessionObserver_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MediaSessionObserver, MediaSessionObserver.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MediaSessionObserver, MediaSessionObserver.Proxy>() {

        @Override
        public String getName() {
            return "media_session.mojom.MediaSessionObserver";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MediaSessionObserver impl) {
            return new Stub(core, impl);
        }

        @Override
        public MediaSessionObserver[] buildArray(int size) {
          return new MediaSessionObserver[size];
        }
    };


    private static final int MEDIA_SESSION_INFO_CHANGED_ORDINAL = 0;

    private static final int MEDIA_SESSION_METADATA_CHANGED_ORDINAL = 1;

    private static final int MEDIA_SESSION_ACTIONS_CHANGED_ORDINAL = 2;

    private static final int MEDIA_SESSION_IMAGES_CHANGED_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MediaSessionObserver.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void mediaSessionInfoChanged(
MediaSessionInfo info) {

            MediaSessionObserverMediaSessionInfoChangedParams _message = new MediaSessionObserverMediaSessionInfoChangedParams();

            _message.info = info;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(MEDIA_SESSION_INFO_CHANGED_ORDINAL)));

        }


        @Override
        public void mediaSessionMetadataChanged(
MediaMetadata metadata) {

            MediaSessionObserverMediaSessionMetadataChangedParams _message = new MediaSessionObserverMediaSessionMetadataChangedParams();

            _message.metadata = metadata;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(MEDIA_SESSION_METADATA_CHANGED_ORDINAL)));

        }


        @Override
        public void mediaSessionActionsChanged(
int[] action) {

            MediaSessionObserverMediaSessionActionsChangedParams _message = new MediaSessionObserverMediaSessionActionsChangedParams();

            _message.action = action;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(MEDIA_SESSION_ACTIONS_CHANGED_ORDINAL)));

        }


        @Override
        public void mediaSessionImagesChanged(
java.util.Map<Integer, MediaImage[]> images) {

            MediaSessionObserverMediaSessionImagesChangedParams _message = new MediaSessionObserverMediaSessionImagesChangedParams();

            _message.images = images;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(MEDIA_SESSION_IMAGES_CHANGED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MediaSessionObserver> {

        Stub(com.vccorp.mojo.system.Core core, MediaSessionObserver impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaSessionObserver_Internal.MANAGER, messageWithHeader);





                    case MEDIA_SESSION_INFO_CHANGED_ORDINAL: {

                        MediaSessionObserverMediaSessionInfoChangedParams data =
                                MediaSessionObserverMediaSessionInfoChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().mediaSessionInfoChanged(data.info);
                        return true;
                    }





                    case MEDIA_SESSION_METADATA_CHANGED_ORDINAL: {

                        MediaSessionObserverMediaSessionMetadataChangedParams data =
                                MediaSessionObserverMediaSessionMetadataChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().mediaSessionMetadataChanged(data.metadata);
                        return true;
                    }





                    case MEDIA_SESSION_ACTIONS_CHANGED_ORDINAL: {

                        MediaSessionObserverMediaSessionActionsChangedParams data =
                                MediaSessionObserverMediaSessionActionsChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().mediaSessionActionsChanged(data.action);
                        return true;
                    }





                    case MEDIA_SESSION_IMAGES_CHANGED_ORDINAL: {

                        MediaSessionObserverMediaSessionImagesChangedParams data =
                                MediaSessionObserverMediaSessionImagesChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().mediaSessionImagesChanged(data.images);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaSessionObserver_Internal.MANAGER, messageWithHeader, receiver);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MediaSessionObserverMediaSessionInfoChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public MediaSessionInfo info;

        private MediaSessionObserverMediaSessionInfoChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionObserverMediaSessionInfoChangedParams() {
            this(0);
        }

        public static MediaSessionObserverMediaSessionInfoChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionObserverMediaSessionInfoChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionObserverMediaSessionInfoChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionObserverMediaSessionInfoChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionObserverMediaSessionInfoChangedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.info = MediaSessionInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.info, 8, false);
        }
    }



    
    static final class MediaSessionObserverMediaSessionMetadataChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public MediaMetadata metadata;

        private MediaSessionObserverMediaSessionMetadataChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionObserverMediaSessionMetadataChangedParams() {
            this(0);
        }

        public static MediaSessionObserverMediaSessionMetadataChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionObserverMediaSessionMetadataChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionObserverMediaSessionMetadataChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionObserverMediaSessionMetadataChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionObserverMediaSessionMetadataChangedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.metadata = MediaMetadata.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.metadata, 8, true);
        }
    }



    
    static final class MediaSessionObserverMediaSessionActionsChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int[] action;

        private MediaSessionObserverMediaSessionActionsChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionObserverMediaSessionActionsChangedParams() {
            this(0);
        }

        public static MediaSessionObserverMediaSessionActionsChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionObserverMediaSessionActionsChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionObserverMediaSessionActionsChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionObserverMediaSessionActionsChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionObserverMediaSessionActionsChangedParams(elementsOrVersion);
                    {
                        
                    result.action = decoder0.readInts(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    {
                        for (int i0 = 0; i0 < result.action.length; ++i0) {
                            MediaSessionAction.validate(result.action[i0]);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.action, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }



    
    static final class MediaSessionObserverMediaSessionImagesChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public java.util.Map<Integer, MediaImage[]> images;

        private MediaSessionObserverMediaSessionImagesChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionObserverMediaSessionImagesChangedParams() {
            this(0);
        }

        public static MediaSessionObserverMediaSessionImagesChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionObserverMediaSessionImagesChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionObserverMediaSessionImagesChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionObserverMediaSessionImagesChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionObserverMediaSessionImagesChangedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        decoder1.readDataHeaderForMap();
                        int[] keys0;
                        MediaImage[][] values0;
                        {
                            
                            keys0 = decoder1.readInts(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                            {
                                for (int i1 = 0; i1 < keys0.length; ++i1) {
                                    MediaSessionImageType.validate(keys0[i1]);
                                }
                            }
                        }
                        {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, false);
                            {
                                com.vccorp.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(keys0.length);
                                values0 = new MediaImage[si2.elementsOrVersion][];
                                for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                                    
                                    com.vccorp.mojo.bindings.Decoder decoder3 = decoder2.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                                    {
                                        com.vccorp.mojo.bindings.DataHeader si3 = decoder3.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                                        values0[i2] = new MediaImage[si3.elementsOrVersion];
                                        for (int i3 = 0; i3 < si3.elementsOrVersion; ++i3) {
                                            
                                            com.vccorp.mojo.bindings.Decoder decoder4 = decoder3.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i3, false);
                                            values0[i2][i3] = MediaImage.decode(decoder4);
                                        }
                                    }
                                }
                            }
                        }
                        result.images = new java.util.HashMap<Integer, MediaImage[]>();
                        for (int index0 = 0; index0 < keys0.length; ++index0) {
                            result.images.put(keys0[index0],  values0[index0]);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.images == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encoderForMap(8);
                int size0 = this.images.size();
                int[] keys0 = new int[size0];
                MediaImage[][] values0 = new MediaImage[size0][];
                int index0 = 0;
                for (java.util.Map.Entry<Integer, MediaImage[]> entry0 : this.images.entrySet()) {
                    keys0[index0] = entry0.getKey();
                    values0[index0] = entry0.getValue();
                    ++index0;
                }
                
                encoder1.encode(keys0, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                
                {
                    org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(values0.length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    for (int i1 = 0; i1 < values0.length; ++i1) {
                        
                        if (values0[i1] == null) {
                            encoder2.encodeNullPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        } else {
                            org.chromium.mojo.bindings.Encoder encoder3 = encoder2.encodePointerArray(values0[i1].length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                            for (int i2 = 0; i2 < values0[i1].length; ++i2) {
                                
                                encoder3.encode(values0[i1][i2], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                            }
                        }
                    }
                }
            }
        }
    }



}
