
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/media_session/public/mojom/media_session.mojom
//

package com.vccorp.media_session.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class MediaSessionInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0),new com.vccorp.mojo.bindings.DataHeader(24, 1),new com.vccorp.mojo.bindings.DataHeader(24, 2),new com.vccorp.mojo.bindings.DataHeader(24, 4)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[3];

    public static final class SessionState {
        private static final boolean IS_EXTENSIBLE = true;

        public static final int ACTIVE = 0;
        public static final int DUCKING = 1; // ACTIVE + 1
        public static final int SUSPENDED = 2; // DUCKING + 1
        public static final int INACTIVE = 3; // SUSPENDED + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 3;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private SessionState() {}
    }
    public int state;
    public boolean forceDuck;
    public int playbackState;
    public boolean isControllable;
    public boolean preferStopForGainFocusLoss;

    private MediaSessionInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public MediaSessionInfo() {
        this(4);
    }

    public static MediaSessionInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static MediaSessionInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static MediaSessionInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        MediaSessionInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new MediaSessionInfo(elementsOrVersion);
                {
                    
                result.state = decoder0.readInt(8);
                    MediaSessionInfo.SessionState.validate(result.state);
                }
                {
                    
                result.forceDuck = decoder0.readBoolean(12, 0);
                }
            if (elementsOrVersion >= 2) {
                {
                    
                result.isControllable = decoder0.readBoolean(12, 1);
                }
            }
            if (elementsOrVersion >= 4) {
                {
                    
                result.preferStopForGainFocusLoss = decoder0.readBoolean(12, 2);
                }
            }
            if (elementsOrVersion >= 1) {
                {
                    
                result.playbackState = decoder0.readInt(16);
                    MediaPlaybackState.validate(result.playbackState);
                }
            }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.state, 8);
        
        encoder0.encode(this.forceDuck, 12, 0);
        
        encoder0.encode(this.isControllable, 12, 1);
        
        encoder0.encode(this.preferStopForGainFocusLoss, 12, 2);
        
        encoder0.encode(this.playbackState, 16);
    }
}