
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/media_session/public/mojom/media_session.mojom
//

package com.vccorp.media_session.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface MediaSession extends com.vccorp.mojo.bindings.Interface {



    public static final class SuspendType {
        private static final boolean IS_EXTENSIBLE = true;

        public static final int SYSTEM = 0;
        public static final int UI = 1; // SYSTEM + 1
        public static final int CONTENT = 2; // UI + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 2;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private SuspendType() {}
    }


    public interface Proxy extends MediaSession, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<MediaSession, MediaSession.Proxy> MANAGER = MediaSession_Internal.MANAGER;


    void getMediaSessionInfo(

GetMediaSessionInfoResponse callback);

    interface GetMediaSessionInfoResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<MediaSessionInfo> { }



    void getDebugInfo(

GetDebugInfoResponse callback);

    interface GetDebugInfoResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<MediaSessionDebugInfo> { }



    void startDucking(
);



    void stopDucking(
);



    void suspend(
int suspendType);



    void resume(
int suspendType);



    void addObserver(
MediaSessionObserver observer);



    void previousTrack(
);



    void nextTrack(
);



    void seek(
com.vccorp.mojo_base.mojom.TimeDelta seekTime);



    void stop(
int suspendType);



    void skipAd(
);



    void getMediaImageBitmap(
MediaImage image, int minimumSizePx, int desiredSizePx, 
GetMediaImageBitmapResponse callback);

    interface GetMediaImageBitmapResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<MediaImageBitmap> { }


}
