
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/video_encode_accelerator.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class VideoEncodeAccelerator_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<VideoEncodeAccelerator, VideoEncodeAccelerator.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<VideoEncodeAccelerator, VideoEncodeAccelerator.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.VideoEncodeAccelerator";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, VideoEncodeAccelerator impl) {
            return new Stub(core, impl);
        }

        @Override
        public VideoEncodeAccelerator[] buildArray(int size) {
          return new VideoEncodeAccelerator[size];
        }
    };


    private static final int INITIALIZE_ORDINAL = 0;

    private static final int ENCODE_ORDINAL = 1;

    private static final int USE_OUTPUT_BITSTREAM_BUFFER_ORDINAL = 2;

    private static final int REQUEST_ENCODING_PARAMETERS_CHANGE_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements VideoEncodeAccelerator.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void initialize(
VideoEncodeAcceleratorConfig config, VideoEncodeAcceleratorClient client, 
InitializeResponse callback) {

            VideoEncodeAcceleratorInitializeParams _message = new VideoEncodeAcceleratorInitializeParams();

            _message.config = config;

            _message.client = client;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIALIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VideoEncodeAcceleratorInitializeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void encode(
VideoFrame frame, boolean forceKeyframe, 
EncodeResponse callback) {

            VideoEncodeAcceleratorEncodeParams _message = new VideoEncodeAcceleratorEncodeParams();

            _message.frame = frame;

            _message.forceKeyframe = forceKeyframe;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENCODE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VideoEncodeAcceleratorEncodeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void useOutputBitstreamBuffer(
int bitstreamBufferId, com.vccorp.mojo.system.SharedBufferHandle buffer) {

            VideoEncodeAcceleratorUseOutputBitstreamBufferParams _message = new VideoEncodeAcceleratorUseOutputBitstreamBufferParams();

            _message.bitstreamBufferId = bitstreamBufferId;

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(USE_OUTPUT_BITSTREAM_BUFFER_ORDINAL)));

        }


        @Override
        public void requestEncodingParametersChange(
VideoBitrateAllocation bitrateAllocation, int framerate) {

            VideoEncodeAcceleratorRequestEncodingParametersChangeParams _message = new VideoEncodeAcceleratorRequestEncodingParametersChangeParams();

            _message.bitrateAllocation = bitrateAllocation;

            _message.framerate = framerate;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REQUEST_ENCODING_PARAMETERS_CHANGE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<VideoEncodeAccelerator> {

        Stub(com.vccorp.mojo.system.Core core, VideoEncodeAccelerator impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                VideoEncodeAccelerator_Internal.MANAGER, messageWithHeader);









                    case USE_OUTPUT_BITSTREAM_BUFFER_ORDINAL: {

                        VideoEncodeAcceleratorUseOutputBitstreamBufferParams data =
                                VideoEncodeAcceleratorUseOutputBitstreamBufferParams.deserialize(messageWithHeader.getPayload());

                        getImpl().useOutputBitstreamBuffer(data.bitstreamBufferId, data.buffer);
                        return true;
                    }





                    case REQUEST_ENCODING_PARAMETERS_CHANGE_ORDINAL: {

                        VideoEncodeAcceleratorRequestEncodingParametersChangeParams data =
                                VideoEncodeAcceleratorRequestEncodingParametersChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestEncodingParametersChange(data.bitrateAllocation, data.framerate);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), VideoEncodeAccelerator_Internal.MANAGER, messageWithHeader, receiver);







                    case INITIALIZE_ORDINAL: {

                        VideoEncodeAcceleratorInitializeParams data =
                                VideoEncodeAcceleratorInitializeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().initialize(data.config, data.client, new VideoEncodeAcceleratorInitializeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ENCODE_ORDINAL: {

                        VideoEncodeAcceleratorEncodeParams data =
                                VideoEncodeAcceleratorEncodeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().encode(data.frame, data.forceKeyframe, new VideoEncodeAcceleratorEncodeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class VideoEncodeAcceleratorInitializeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoEncodeAcceleratorConfig config;
        public VideoEncodeAcceleratorClient client;

        private VideoEncodeAcceleratorInitializeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoEncodeAcceleratorInitializeParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorInitializeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorInitializeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorInitializeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorInitializeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorInitializeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.config = VideoEncodeAcceleratorConfig.decode(decoder1);
                    }
                    {
                        
                    result.client = decoder0.readServiceInterface(16, false, VideoEncodeAcceleratorClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.config, 8, false);
            
            encoder0.encode(this.client, 16, false, VideoEncodeAcceleratorClient.MANAGER);
        }
    }



    
    static final class VideoEncodeAcceleratorInitializeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean result;

        private VideoEncodeAcceleratorInitializeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoEncodeAcceleratorInitializeResponseParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorInitializeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorInitializeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorInitializeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorInitializeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorInitializeResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, 0);
        }
    }

    static class VideoEncodeAcceleratorInitializeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VideoEncodeAccelerator.InitializeResponse mCallback;

        VideoEncodeAcceleratorInitializeResponseParamsForwardToCallback(VideoEncodeAccelerator.InitializeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(INITIALIZE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                VideoEncodeAcceleratorInitializeResponseParams response = VideoEncodeAcceleratorInitializeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VideoEncodeAcceleratorInitializeResponseParamsProxyToResponder implements VideoEncodeAccelerator.InitializeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VideoEncodeAcceleratorInitializeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean result) {
            VideoEncodeAcceleratorInitializeResponseParams _response = new VideoEncodeAcceleratorInitializeResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIALIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class VideoEncodeAcceleratorEncodeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoFrame frame;
        public boolean forceKeyframe;

        private VideoEncodeAcceleratorEncodeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoEncodeAcceleratorEncodeParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorEncodeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorEncodeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorEncodeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorEncodeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorEncodeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.frame = VideoFrame.decode(decoder1);
                    }
                    {
                        
                    result.forceKeyframe = decoder0.readBoolean(16, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.frame, 8, false);
            
            encoder0.encode(this.forceKeyframe, 16, 0);
        }
    }



    
    static final class VideoEncodeAcceleratorEncodeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VideoEncodeAcceleratorEncodeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoEncodeAcceleratorEncodeResponseParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorEncodeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorEncodeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorEncodeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorEncodeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorEncodeResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class VideoEncodeAcceleratorEncodeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VideoEncodeAccelerator.EncodeResponse mCallback;

        VideoEncodeAcceleratorEncodeResponseParamsForwardToCallback(VideoEncodeAccelerator.EncodeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ENCODE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VideoEncodeAcceleratorEncodeResponseParamsProxyToResponder implements VideoEncodeAccelerator.EncodeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VideoEncodeAcceleratorEncodeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            VideoEncodeAcceleratorEncodeResponseParams _response = new VideoEncodeAcceleratorEncodeResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENCODE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class VideoEncodeAcceleratorUseOutputBitstreamBufferParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int bitstreamBufferId;
        public com.vccorp.mojo.system.SharedBufferHandle buffer;

        private VideoEncodeAcceleratorUseOutputBitstreamBufferParams(int version) {
            super(STRUCT_SIZE, version);
            this.buffer = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public VideoEncodeAcceleratorUseOutputBitstreamBufferParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorUseOutputBitstreamBufferParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorUseOutputBitstreamBufferParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorUseOutputBitstreamBufferParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorUseOutputBitstreamBufferParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorUseOutputBitstreamBufferParams(elementsOrVersion);
                    {
                        
                    result.bitstreamBufferId = decoder0.readInt(8);
                    }
                    {
                        
                    result.buffer = decoder0.readSharedBufferHandle(12, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bitstreamBufferId, 8);
            
            encoder0.encode(this.buffer, 12, false);
        }
    }



    
    static final class VideoEncodeAcceleratorRequestEncodingParametersChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoBitrateAllocation bitrateAllocation;
        public int framerate;

        private VideoEncodeAcceleratorRequestEncodingParametersChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoEncodeAcceleratorRequestEncodingParametersChangeParams() {
            this(0);
        }

        public static VideoEncodeAcceleratorRequestEncodingParametersChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoEncodeAcceleratorRequestEncodingParametersChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoEncodeAcceleratorRequestEncodingParametersChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoEncodeAcceleratorRequestEncodingParametersChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoEncodeAcceleratorRequestEncodingParametersChangeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.bitrateAllocation = VideoBitrateAllocation.decode(decoder1);
                    }
                    {
                        
                    result.framerate = decoder0.readInt(16);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bitrateAllocation, 8, false);
            
            encoder0.encode(this.framerate, 16);
        }
    }



}
