
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/media_metrics_provider.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MediaMetricsProvider_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MediaMetricsProvider, MediaMetricsProvider.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MediaMetricsProvider, MediaMetricsProvider.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.MediaMetricsProvider";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MediaMetricsProvider impl) {
            return new Stub(core, impl);
        }

        @Override
        public MediaMetricsProvider[] buildArray(int size) {
          return new MediaMetricsProvider[size];
        }
    };


    private static final int INITIALIZE_ORDINAL = 0;

    private static final int ON_ERROR_ORDINAL = 1;

    private static final int SET_IS_AD_MEDIA_ORDINAL = 2;

    private static final int SET_IS_EME_ORDINAL = 3;

    private static final int SET_TIME_TO_METADATA_ORDINAL = 4;

    private static final int SET_TIME_TO_FIRST_FRAME_ORDINAL = 5;

    private static final int SET_TIME_TO_PLAY_READY_ORDINAL = 6;

    private static final int SET_CONTAINER_NAME_ORDINAL = 7;

    private static final int ACQUIRE_WATCH_TIME_RECORDER_ORDINAL = 8;

    private static final int ACQUIRE_VIDEO_DECODE_STATS_RECORDER_ORDINAL = 9;

    private static final int ADD_BYTES_RECEIVED_ORDINAL = 10;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MediaMetricsProvider.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void initialize(
boolean isMse, int urlScheme) {

            MediaMetricsProviderInitializeParams _message = new MediaMetricsProviderInitializeParams();

            _message.isMse = isMse;

            _message.urlScheme = urlScheme;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(INITIALIZE_ORDINAL)));

        }


        @Override
        public void onError(
int status) {

            MediaMetricsProviderOnErrorParams _message = new MediaMetricsProviderOnErrorParams();

            _message.status = status;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ERROR_ORDINAL)));

        }


        @Override
        public void setIsAdMedia(
) {

            MediaMetricsProviderSetIsAdMediaParams _message = new MediaMetricsProviderSetIsAdMediaParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_IS_AD_MEDIA_ORDINAL)));

        }


        @Override
        public void setIsEme(
) {

            MediaMetricsProviderSetIsEmeParams _message = new MediaMetricsProviderSetIsEmeParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_IS_EME_ORDINAL)));

        }


        @Override
        public void setTimeToMetadata(
com.vccorp.mojo_base.mojom.TimeDelta elapsed) {

            MediaMetricsProviderSetTimeToMetadataParams _message = new MediaMetricsProviderSetTimeToMetadataParams();

            _message.elapsed = elapsed;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_TIME_TO_METADATA_ORDINAL)));

        }


        @Override
        public void setTimeToFirstFrame(
com.vccorp.mojo_base.mojom.TimeDelta elapsed) {

            MediaMetricsProviderSetTimeToFirstFrameParams _message = new MediaMetricsProviderSetTimeToFirstFrameParams();

            _message.elapsed = elapsed;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_TIME_TO_FIRST_FRAME_ORDINAL)));

        }


        @Override
        public void setTimeToPlayReady(
com.vccorp.mojo_base.mojom.TimeDelta elapsed) {

            MediaMetricsProviderSetTimeToPlayReadyParams _message = new MediaMetricsProviderSetTimeToPlayReadyParams();

            _message.elapsed = elapsed;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_TIME_TO_PLAY_READY_ORDINAL)));

        }


        @Override
        public void setContainerName(
int containerName) {

            MediaMetricsProviderSetContainerNameParams _message = new MediaMetricsProviderSetContainerNameParams();

            _message.containerName = containerName;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_CONTAINER_NAME_ORDINAL)));

        }


        @Override
        public void acquireWatchTimeRecorder(
PlaybackProperties properties, com.vccorp.mojo.bindings.InterfaceRequest<WatchTimeRecorder> recorder) {

            MediaMetricsProviderAcquireWatchTimeRecorderParams _message = new MediaMetricsProviderAcquireWatchTimeRecorderParams();

            _message.properties = properties;

            _message.recorder = recorder;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ACQUIRE_WATCH_TIME_RECORDER_ORDINAL)));

        }


        @Override
        public void acquireVideoDecodeStatsRecorder(
com.vccorp.mojo.bindings.InterfaceRequest<VideoDecodeStatsRecorder> recorder) {

            MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams _message = new MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams();

            _message.recorder = recorder;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ACQUIRE_VIDEO_DECODE_STATS_RECORDER_ORDINAL)));

        }


        @Override
        public void addBytesReceived(
long bytesReceived) {

            MediaMetricsProviderAddBytesReceivedParams _message = new MediaMetricsProviderAddBytesReceivedParams();

            _message.bytesReceived = bytesReceived;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ADD_BYTES_RECEIVED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MediaMetricsProvider> {

        Stub(com.vccorp.mojo.system.Core core, MediaMetricsProvider impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaMetricsProvider_Internal.MANAGER, messageWithHeader);





                    case INITIALIZE_ORDINAL: {

                        MediaMetricsProviderInitializeParams data =
                                MediaMetricsProviderInitializeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().initialize(data.isMse, data.urlScheme);
                        return true;
                    }





                    case ON_ERROR_ORDINAL: {

                        MediaMetricsProviderOnErrorParams data =
                                MediaMetricsProviderOnErrorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onError(data.status);
                        return true;
                    }





                    case SET_IS_AD_MEDIA_ORDINAL: {

                        MediaMetricsProviderSetIsAdMediaParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setIsAdMedia();
                        return true;
                    }





                    case SET_IS_EME_ORDINAL: {

                        MediaMetricsProviderSetIsEmeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setIsEme();
                        return true;
                    }





                    case SET_TIME_TO_METADATA_ORDINAL: {

                        MediaMetricsProviderSetTimeToMetadataParams data =
                                MediaMetricsProviderSetTimeToMetadataParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setTimeToMetadata(data.elapsed);
                        return true;
                    }





                    case SET_TIME_TO_FIRST_FRAME_ORDINAL: {

                        MediaMetricsProviderSetTimeToFirstFrameParams data =
                                MediaMetricsProviderSetTimeToFirstFrameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setTimeToFirstFrame(data.elapsed);
                        return true;
                    }





                    case SET_TIME_TO_PLAY_READY_ORDINAL: {

                        MediaMetricsProviderSetTimeToPlayReadyParams data =
                                MediaMetricsProviderSetTimeToPlayReadyParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setTimeToPlayReady(data.elapsed);
                        return true;
                    }





                    case SET_CONTAINER_NAME_ORDINAL: {

                        MediaMetricsProviderSetContainerNameParams data =
                                MediaMetricsProviderSetContainerNameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setContainerName(data.containerName);
                        return true;
                    }





                    case ACQUIRE_WATCH_TIME_RECORDER_ORDINAL: {

                        MediaMetricsProviderAcquireWatchTimeRecorderParams data =
                                MediaMetricsProviderAcquireWatchTimeRecorderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().acquireWatchTimeRecorder(data.properties, data.recorder);
                        return true;
                    }





                    case ACQUIRE_VIDEO_DECODE_STATS_RECORDER_ORDINAL: {

                        MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams data =
                                MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().acquireVideoDecodeStatsRecorder(data.recorder);
                        return true;
                    }





                    case ADD_BYTES_RECEIVED_ORDINAL: {

                        MediaMetricsProviderAddBytesReceivedParams data =
                                MediaMetricsProviderAddBytesReceivedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addBytesReceived(data.bytesReceived);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaMetricsProvider_Internal.MANAGER, messageWithHeader, receiver);
























                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MediaMetricsProviderInitializeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean isMse;
        public int urlScheme;

        private MediaMetricsProviderInitializeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderInitializeParams() {
            this(0);
        }

        public static MediaMetricsProviderInitializeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderInitializeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderInitializeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderInitializeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderInitializeParams(elementsOrVersion);
                    {
                        
                    result.isMse = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.urlScheme = decoder0.readInt(12);
                        MediaUrlScheme.validate(result.urlScheme);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.isMse, 8, 0);
            
            encoder0.encode(this.urlScheme, 12);
        }
    }



    
    static final class MediaMetricsProviderOnErrorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private MediaMetricsProviderOnErrorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderOnErrorParams() {
            this(0);
        }

        public static MediaMetricsProviderOnErrorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderOnErrorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderOnErrorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderOnErrorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderOnErrorParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        PipelineStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }



    
    static final class MediaMetricsProviderSetIsAdMediaParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private MediaMetricsProviderSetIsAdMediaParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderSetIsAdMediaParams() {
            this(0);
        }

        public static MediaMetricsProviderSetIsAdMediaParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderSetIsAdMediaParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderSetIsAdMediaParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderSetIsAdMediaParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderSetIsAdMediaParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class MediaMetricsProviderSetIsEmeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private MediaMetricsProviderSetIsEmeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderSetIsEmeParams() {
            this(0);
        }

        public static MediaMetricsProviderSetIsEmeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderSetIsEmeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderSetIsEmeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderSetIsEmeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderSetIsEmeParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class MediaMetricsProviderSetTimeToMetadataParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.TimeDelta elapsed;

        private MediaMetricsProviderSetTimeToMetadataParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderSetTimeToMetadataParams() {
            this(0);
        }

        public static MediaMetricsProviderSetTimeToMetadataParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderSetTimeToMetadataParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderSetTimeToMetadataParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderSetTimeToMetadataParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderSetTimeToMetadataParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.elapsed = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.elapsed, 8, false);
        }
    }



    
    static final class MediaMetricsProviderSetTimeToFirstFrameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.TimeDelta elapsed;

        private MediaMetricsProviderSetTimeToFirstFrameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderSetTimeToFirstFrameParams() {
            this(0);
        }

        public static MediaMetricsProviderSetTimeToFirstFrameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderSetTimeToFirstFrameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderSetTimeToFirstFrameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderSetTimeToFirstFrameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderSetTimeToFirstFrameParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.elapsed = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.elapsed, 8, false);
        }
    }



    
    static final class MediaMetricsProviderSetTimeToPlayReadyParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.TimeDelta elapsed;

        private MediaMetricsProviderSetTimeToPlayReadyParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderSetTimeToPlayReadyParams() {
            this(0);
        }

        public static MediaMetricsProviderSetTimeToPlayReadyParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderSetTimeToPlayReadyParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderSetTimeToPlayReadyParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderSetTimeToPlayReadyParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderSetTimeToPlayReadyParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.elapsed = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.elapsed, 8, false);
        }
    }



    
    static final class MediaMetricsProviderSetContainerNameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int containerName;

        private MediaMetricsProviderSetContainerNameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderSetContainerNameParams() {
            this(0);
        }

        public static MediaMetricsProviderSetContainerNameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderSetContainerNameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderSetContainerNameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderSetContainerNameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderSetContainerNameParams(elementsOrVersion);
                    {
                        
                    result.containerName = decoder0.readInt(8);
                        MediaContainerName.validate(result.containerName);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.containerName, 8);
        }
    }



    
    static final class MediaMetricsProviderAcquireWatchTimeRecorderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PlaybackProperties properties;
        public com.vccorp.mojo.bindings.InterfaceRequest<WatchTimeRecorder> recorder;

        private MediaMetricsProviderAcquireWatchTimeRecorderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderAcquireWatchTimeRecorderParams() {
            this(0);
        }

        public static MediaMetricsProviderAcquireWatchTimeRecorderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderAcquireWatchTimeRecorderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderAcquireWatchTimeRecorderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderAcquireWatchTimeRecorderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderAcquireWatchTimeRecorderParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.properties = PlaybackProperties.decode(decoder1);
                    }
                    {
                        
                    result.recorder = decoder0.readInterfaceRequest(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.properties, 8, false);
            
            encoder0.encode(this.recorder, 16, false);
        }
    }



    
    static final class MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<VideoDecodeStatsRecorder> recorder;

        private MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams() {
            this(0);
        }

        public static MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderAcquireVideoDecodeStatsRecorderParams(elementsOrVersion);
                    {
                        
                    result.recorder = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.recorder, 8, false);
        }
    }



    
    static final class MediaMetricsProviderAddBytesReceivedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long bytesReceived;

        private MediaMetricsProviderAddBytesReceivedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaMetricsProviderAddBytesReceivedParams() {
            this(0);
        }

        public static MediaMetricsProviderAddBytesReceivedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaMetricsProviderAddBytesReceivedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaMetricsProviderAddBytesReceivedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaMetricsProviderAddBytesReceivedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaMetricsProviderAddBytesReceivedParams(elementsOrVersion);
                    {
                        
                    result.bytesReceived = decoder0.readLong(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bytesReceived, 8);
        }
    }



}
