
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/interface_factory.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class InterfaceFactory_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<InterfaceFactory, InterfaceFactory.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<InterfaceFactory, InterfaceFactory.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.InterfaceFactory";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, InterfaceFactory impl) {
            return new Stub(core, impl);
        }

        @Override
        public InterfaceFactory[] buildArray(int size) {
          return new InterfaceFactory[size];
        }
    };


    private static final int CREATE_AUDIO_DECODER_ORDINAL = 0;

    private static final int CREATE_VIDEO_DECODER_ORDINAL = 1;

    private static final int CREATE_DEFAULT_RENDERER_ORDINAL = 2;

    private static final int CREATE_MEDIA_PLAYER_RENDERER_ORDINAL = 3;

    private static final int CREATE_FLINGING_RENDERER_ORDINAL = 4;

    private static final int CREATE_CDM_ORDINAL = 5;

    private static final int CREATE_DECRYPTOR_ORDINAL = 6;

    private static final int CREATE_CDM_PROXY_ORDINAL = 7;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements InterfaceFactory.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createAudioDecoder(
com.vccorp.mojo.bindings.InterfaceRequest<AudioDecoder> audioDecoder) {

            InterfaceFactoryCreateAudioDecoderParams _message = new InterfaceFactoryCreateAudioDecoderParams();

            _message.audioDecoder = audioDecoder;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_AUDIO_DECODER_ORDINAL)));

        }


        @Override
        public void createVideoDecoder(
com.vccorp.mojo.bindings.InterfaceRequest<VideoDecoder> videoDecoder) {

            InterfaceFactoryCreateVideoDecoderParams _message = new InterfaceFactoryCreateVideoDecoderParams();

            _message.videoDecoder = videoDecoder;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_VIDEO_DECODER_ORDINAL)));

        }


        @Override
        public void createDefaultRenderer(
String audioDeviceId, com.vccorp.mojo.bindings.InterfaceRequest<Renderer> renderer) {

            InterfaceFactoryCreateDefaultRendererParams _message = new InterfaceFactoryCreateDefaultRendererParams();

            _message.audioDeviceId = audioDeviceId;

            _message.renderer = renderer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_DEFAULT_RENDERER_ORDINAL)));

        }


        @Override
        public void createMediaPlayerRenderer(
MediaPlayerRendererClientExtension clientExtension, com.vccorp.mojo.bindings.InterfaceRequest<Renderer> renderer, com.vccorp.mojo.bindings.InterfaceRequest<MediaPlayerRendererExtension> rendererExtension) {

            InterfaceFactoryCreateMediaPlayerRendererParams _message = new InterfaceFactoryCreateMediaPlayerRendererParams();

            _message.clientExtension = clientExtension;

            _message.renderer = renderer;

            _message.rendererExtension = rendererExtension;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_MEDIA_PLAYER_RENDERER_ORDINAL)));

        }


        @Override
        public void createFlingingRenderer(
String presentationId, com.vccorp.mojo.bindings.InterfaceRequest<Renderer> renderer) {

            InterfaceFactoryCreateFlingingRendererParams _message = new InterfaceFactoryCreateFlingingRendererParams();

            _message.presentationId = presentationId;

            _message.renderer = renderer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_FLINGING_RENDERER_ORDINAL)));

        }


        @Override
        public void createCdm(
String keySystem, com.vccorp.mojo.bindings.InterfaceRequest<ContentDecryptionModule> cdm) {

            InterfaceFactoryCreateCdmParams _message = new InterfaceFactoryCreateCdmParams();

            _message.keySystem = keySystem;

            _message.cdm = cdm;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_CDM_ORDINAL)));

        }


        @Override
        public void createDecryptor(
int cdmId, com.vccorp.mojo.bindings.InterfaceRequest<Decryptor> decryptor) {

            InterfaceFactoryCreateDecryptorParams _message = new InterfaceFactoryCreateDecryptorParams();

            _message.cdmId = cdmId;

            _message.decryptor = decryptor;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_DECRYPTOR_ORDINAL)));

        }


        @Override
        public void createCdmProxy(
com.vccorp.mojo_base.mojom.Token cdmGuid, com.vccorp.mojo.bindings.InterfaceRequest<CdmProxy> cdmProxy) {

            InterfaceFactoryCreateCdmProxyParams _message = new InterfaceFactoryCreateCdmProxyParams();

            _message.cdmGuid = cdmGuid;

            _message.cdmProxy = cdmProxy;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_CDM_PROXY_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<InterfaceFactory> {

        Stub(com.vccorp.mojo.system.Core core, InterfaceFactory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                InterfaceFactory_Internal.MANAGER, messageWithHeader);





                    case CREATE_AUDIO_DECODER_ORDINAL: {

                        InterfaceFactoryCreateAudioDecoderParams data =
                                InterfaceFactoryCreateAudioDecoderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createAudioDecoder(data.audioDecoder);
                        return true;
                    }





                    case CREATE_VIDEO_DECODER_ORDINAL: {

                        InterfaceFactoryCreateVideoDecoderParams data =
                                InterfaceFactoryCreateVideoDecoderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createVideoDecoder(data.videoDecoder);
                        return true;
                    }





                    case CREATE_DEFAULT_RENDERER_ORDINAL: {

                        InterfaceFactoryCreateDefaultRendererParams data =
                                InterfaceFactoryCreateDefaultRendererParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createDefaultRenderer(data.audioDeviceId, data.renderer);
                        return true;
                    }





                    case CREATE_MEDIA_PLAYER_RENDERER_ORDINAL: {

                        InterfaceFactoryCreateMediaPlayerRendererParams data =
                                InterfaceFactoryCreateMediaPlayerRendererParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createMediaPlayerRenderer(data.clientExtension, data.renderer, data.rendererExtension);
                        return true;
                    }





                    case CREATE_FLINGING_RENDERER_ORDINAL: {

                        InterfaceFactoryCreateFlingingRendererParams data =
                                InterfaceFactoryCreateFlingingRendererParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createFlingingRenderer(data.presentationId, data.renderer);
                        return true;
                    }





                    case CREATE_CDM_ORDINAL: {

                        InterfaceFactoryCreateCdmParams data =
                                InterfaceFactoryCreateCdmParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createCdm(data.keySystem, data.cdm);
                        return true;
                    }





                    case CREATE_DECRYPTOR_ORDINAL: {

                        InterfaceFactoryCreateDecryptorParams data =
                                InterfaceFactoryCreateDecryptorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createDecryptor(data.cdmId, data.decryptor);
                        return true;
                    }





                    case CREATE_CDM_PROXY_ORDINAL: {

                        InterfaceFactoryCreateCdmProxyParams data =
                                InterfaceFactoryCreateCdmProxyParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createCdmProxy(data.cdmGuid, data.cdmProxy);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), InterfaceFactory_Internal.MANAGER, messageWithHeader, receiver);


















                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class InterfaceFactoryCreateAudioDecoderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<AudioDecoder> audioDecoder;

        private InterfaceFactoryCreateAudioDecoderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public InterfaceFactoryCreateAudioDecoderParams() {
            this(0);
        }

        public static InterfaceFactoryCreateAudioDecoderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static InterfaceFactoryCreateAudioDecoderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static InterfaceFactoryCreateAudioDecoderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            InterfaceFactoryCreateAudioDecoderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new InterfaceFactoryCreateAudioDecoderParams(elementsOrVersion);
                    {
                        
                    result.audioDecoder = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.audioDecoder, 8, false);
        }
    }



    
    static final class InterfaceFactoryCreateVideoDecoderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<VideoDecoder> videoDecoder;

        private InterfaceFactoryCreateVideoDecoderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public InterfaceFactoryCreateVideoDecoderParams() {
            this(0);
        }

        public static InterfaceFactoryCreateVideoDecoderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static InterfaceFactoryCreateVideoDecoderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static InterfaceFactoryCreateVideoDecoderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            InterfaceFactoryCreateVideoDecoderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new InterfaceFactoryCreateVideoDecoderParams(elementsOrVersion);
                    {
                        
                    result.videoDecoder = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.videoDecoder, 8, false);
        }
    }



    
    static final class InterfaceFactoryCreateDefaultRendererParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String audioDeviceId;
        public com.vccorp.mojo.bindings.InterfaceRequest<Renderer> renderer;

        private InterfaceFactoryCreateDefaultRendererParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public InterfaceFactoryCreateDefaultRendererParams() {
            this(0);
        }

        public static InterfaceFactoryCreateDefaultRendererParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static InterfaceFactoryCreateDefaultRendererParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static InterfaceFactoryCreateDefaultRendererParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            InterfaceFactoryCreateDefaultRendererParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new InterfaceFactoryCreateDefaultRendererParams(elementsOrVersion);
                    {
                        
                    result.audioDeviceId = decoder0.readString(8, false);
                    }
                    {
                        
                    result.renderer = decoder0.readInterfaceRequest(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.audioDeviceId, 8, false);
            
            encoder0.encode(this.renderer, 16, false);
        }
    }



    
    static final class InterfaceFactoryCreateMediaPlayerRendererParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public MediaPlayerRendererClientExtension clientExtension;
        public com.vccorp.mojo.bindings.InterfaceRequest<Renderer> renderer;
        public com.vccorp.mojo.bindings.InterfaceRequest<MediaPlayerRendererExtension> rendererExtension;

        private InterfaceFactoryCreateMediaPlayerRendererParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public InterfaceFactoryCreateMediaPlayerRendererParams() {
            this(0);
        }

        public static InterfaceFactoryCreateMediaPlayerRendererParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static InterfaceFactoryCreateMediaPlayerRendererParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static InterfaceFactoryCreateMediaPlayerRendererParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            InterfaceFactoryCreateMediaPlayerRendererParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new InterfaceFactoryCreateMediaPlayerRendererParams(elementsOrVersion);
                    {
                        
                    result.clientExtension = decoder0.readServiceInterface(8, false, MediaPlayerRendererClientExtension.MANAGER);
                    }
                    {
                        
                    result.renderer = decoder0.readInterfaceRequest(16, false);
                    }
                    {
                        
                    result.rendererExtension = decoder0.readInterfaceRequest(20, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.clientExtension, 8, false, MediaPlayerRendererClientExtension.MANAGER);
            
            encoder0.encode(this.renderer, 16, false);
            
            encoder0.encode(this.rendererExtension, 20, false);
        }
    }



    
    static final class InterfaceFactoryCreateFlingingRendererParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String presentationId;
        public com.vccorp.mojo.bindings.InterfaceRequest<Renderer> renderer;

        private InterfaceFactoryCreateFlingingRendererParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public InterfaceFactoryCreateFlingingRendererParams() {
            this(0);
        }

        public static InterfaceFactoryCreateFlingingRendererParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static InterfaceFactoryCreateFlingingRendererParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static InterfaceFactoryCreateFlingingRendererParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            InterfaceFactoryCreateFlingingRendererParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new InterfaceFactoryCreateFlingingRendererParams(elementsOrVersion);
                    {
                        
                    result.presentationId = decoder0.readString(8, false);
                    }
                    {
                        
                    result.renderer = decoder0.readInterfaceRequest(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.presentationId, 8, false);
            
            encoder0.encode(this.renderer, 16, false);
        }
    }



    
    static final class InterfaceFactoryCreateCdmParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String keySystem;
        public com.vccorp.mojo.bindings.InterfaceRequest<ContentDecryptionModule> cdm;

        private InterfaceFactoryCreateCdmParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public InterfaceFactoryCreateCdmParams() {
            this(0);
        }

        public static InterfaceFactoryCreateCdmParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static InterfaceFactoryCreateCdmParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static InterfaceFactoryCreateCdmParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            InterfaceFactoryCreateCdmParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new InterfaceFactoryCreateCdmParams(elementsOrVersion);
                    {
                        
                    result.keySystem = decoder0.readString(8, false);
                    }
                    {
                        
                    result.cdm = decoder0.readInterfaceRequest(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.keySystem, 8, false);
            
            encoder0.encode(this.cdm, 16, false);
        }
    }



    
    static final class InterfaceFactoryCreateDecryptorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int cdmId;
        public com.vccorp.mojo.bindings.InterfaceRequest<Decryptor> decryptor;

        private InterfaceFactoryCreateDecryptorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public InterfaceFactoryCreateDecryptorParams() {
            this(0);
        }

        public static InterfaceFactoryCreateDecryptorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static InterfaceFactoryCreateDecryptorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static InterfaceFactoryCreateDecryptorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            InterfaceFactoryCreateDecryptorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new InterfaceFactoryCreateDecryptorParams(elementsOrVersion);
                    {
                        
                    result.cdmId = decoder0.readInt(8);
                    }
                    {
                        
                    result.decryptor = decoder0.readInterfaceRequest(12, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cdmId, 8);
            
            encoder0.encode(this.decryptor, 12, false);
        }
    }



    
    static final class InterfaceFactoryCreateCdmProxyParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.Token cdmGuid;
        public com.vccorp.mojo.bindings.InterfaceRequest<CdmProxy> cdmProxy;

        private InterfaceFactoryCreateCdmProxyParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public InterfaceFactoryCreateCdmProxyParams() {
            this(0);
        }

        public static InterfaceFactoryCreateCdmProxyParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static InterfaceFactoryCreateCdmProxyParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static InterfaceFactoryCreateCdmProxyParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            InterfaceFactoryCreateCdmProxyParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new InterfaceFactoryCreateCdmProxyParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.cdmGuid = com.vccorp.mojo_base.mojom.Token.decode(decoder1);
                    }
                    {
                        
                    result.cdmProxy = decoder0.readInterfaceRequest(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cdmGuid, 8, false);
            
            encoder0.encode(this.cdmProxy, 16, false);
        }
    }



}
