
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/mjpeg_decode_accelerator.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class BitstreamBuffer extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 64;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(64, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int id;
    public com.vccorp.mojo.system.SharedBufferHandle memoryHandle;
    public int size;
    public long offset;
    public com.vccorp.mojo_base.mojom.TimeDelta timestamp;
    public String keyId;
    public String iv;
    public SubsampleEntry[] subsamples;

    private BitstreamBuffer(int version) {
        super(STRUCT_SIZE, version);
        this.memoryHandle = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
    }

    public BitstreamBuffer() {
        this(0);
    }

    public static BitstreamBuffer deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static BitstreamBuffer deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static BitstreamBuffer decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        BitstreamBuffer result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new BitstreamBuffer(elementsOrVersion);
                {
                    
                result.id = decoder0.readInt(8);
                }
                {
                    
                result.memoryHandle = decoder0.readSharedBufferHandle(12, false);
                }
                {
                    
                result.size = decoder0.readInt(16);
                }
                {
                    
                result.offset = decoder0.readLong(24);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.timestamp = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }
                {
                    
                result.keyId = decoder0.readString(40, false);
                }
                {
                    
                result.iv = decoder0.readString(48, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.subsamples = new SubsampleEntry[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.subsamples[i1] = SubsampleEntry.decode(decoder2);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.id, 8);
        
        encoder0.encode(this.memoryHandle, 12, false);
        
        encoder0.encode(this.size, 16);
        
        encoder0.encode(this.offset, 24);
        
        encoder0.encode(this.timestamp, 32, false);
        
        encoder0.encode(this.keyId, 40, false);
        
        encoder0.encode(this.iv, 48, false);
        
        if (this.subsamples == null) {
            encoder0.encodeNullPointer(56, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.subsamples.length, 56, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.subsamples.length; ++i0) {
                
                encoder1.encode(this.subsamples[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }
}