
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     ui/gfx/mojo/color_space.mojom
//

package com.vccorp.gfx.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ColorSpacePrimaryId {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int INVALID = 0;
    public static final int BT709 = 1; // INVALID + 1
    public static final int BT470M = 2; // BT709 + 1
    public static final int BT470BG = 3; // BT470M + 1
    public static final int SMPTE170M = 4; // BT470BG + 1
    public static final int SMPTE240M = 5; // SMPTE170M + 1
    public static final int FILM = 6; // SMPTE240M + 1
    public static final int BT2020 = 7; // FILM + 1
    public static final int SMPTEST428_1 = 8; // BT2020 + 1
    public static final int SMPTEST431_2 = 9; // SMPTEST428_1 + 1
    public static final int SMPTEST432_1 = 10; // SMPTEST431_2 + 1
    public static final int XYZ_D50 = 11; // SMPTEST432_1 + 1
    public static final int ADOBE_RGB = 12; // XYZ_D50 + 1
    public static final int APPLE_GENERIC_RGB = 13; // ADOBE_RGB + 1
    public static final int WIDE_GAMUT_COLOR_SPIN = 14; // APPLE_GENERIC_RGB + 1
    public static final int CUSTOM = 15; // WIDE_GAMUT_COLOR_SPIN + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 15;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ColorSpacePrimaryId() {}
}