
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/usb/public/mojom/device.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class UsbTransferStatus {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int COMPLETED = 0;
    public static final int TRANSFER_ERROR = 1; // COMPLETED + 1
    public static final int TIMEOUT = 2; // TRANSFER_ERROR + 1
    public static final int CANCELLED = 3; // TIMEOUT + 1
    public static final int STALLED = 4; // CANCELLED + 1
    public static final int DISCONNECT = 5; // STALLED + 1
    public static final int BABBLE = 6; // DISCONNECT + 1
    public static final int SHORT_PACKET = 7; // BABBLE + 1
    public static final int PERMISSION_DENIED = 8; // SHORT_PACKET + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 8;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private UsbTransferStatus() {}
}