
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/usb/public/mojom/device_enumeration_options.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class UsbDeviceFilter extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public boolean hasVendorId;
    public short vendorId;
    public boolean hasProductId;
    public short productId;
    public boolean hasClassCode;
    public byte classCode;
    public boolean hasSubclassCode;
    public byte subclassCode;
    public boolean hasProtocolCode;
    public byte protocolCode;
    public com.vccorp.mojo_base.mojom.String16 serialNumber;

    private UsbDeviceFilter(int version) {
        super(STRUCT_SIZE, version);
    }

    public UsbDeviceFilter() {
        this(0);
    }

    public static UsbDeviceFilter deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static UsbDeviceFilter deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static UsbDeviceFilter decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        UsbDeviceFilter result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new UsbDeviceFilter(elementsOrVersion);
                {
                    
                result.hasVendorId = decoder0.readBoolean(8, 0);
                }
                {
                    
                result.hasProductId = decoder0.readBoolean(8, 1);
                }
                {
                    
                result.hasClassCode = decoder0.readBoolean(8, 2);
                }
                {
                    
                result.hasSubclassCode = decoder0.readBoolean(8, 3);
                }
                {
                    
                result.hasProtocolCode = decoder0.readBoolean(8, 4);
                }
                {
                    
                result.classCode = decoder0.readByte(9);
                }
                {
                    
                result.vendorId = decoder0.readShort(10);
                }
                {
                    
                result.productId = decoder0.readShort(12);
                }
                {
                    
                result.subclassCode = decoder0.readByte(14);
                }
                {
                    
                result.protocolCode = decoder0.readByte(15);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.serialNumber = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.hasVendorId, 8, 0);
        
        encoder0.encode(this.hasProductId, 8, 1);
        
        encoder0.encode(this.hasClassCode, 8, 2);
        
        encoder0.encode(this.hasSubclassCode, 8, 3);
        
        encoder0.encode(this.hasProtocolCode, 8, 4);
        
        encoder0.encode(this.classCode, 9);
        
        encoder0.encode(this.vendorId, 10);
        
        encoder0.encode(this.productId, 12);
        
        encoder0.encode(this.subclassCode, 14);
        
        encoder0.encode(this.protocolCode, 15);
        
        encoder0.encode(this.serialNumber, 16, true);
    }
}