
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/device/public/mojom/nfc.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class NfcErrorType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int SECURITY = 0;
    public static final int NOT_SUPPORTED = 1; // SECURITY + 1
    public static final int DEVICE_DISABLED = 2; // NOT_SUPPORTED + 1
    public static final int NOT_FOUND = 3; // DEVICE_DISABLED + 1
    public static final int INVALID_MESSAGE = 4; // NOT_FOUND + 1
    public static final int OPERATION_CANCELLED = 5; // INVALID_MESSAGE + 1
    public static final int TIMER_EXPIRED = 6; // OPERATION_CANCELLED + 1
    public static final int CANNOT_CANCEL = 7; // TIMER_EXPIRED + 1
    public static final int IO_ERROR = 8; // CANNOT_CANCEL + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 8;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private NfcErrorType() {}
}