
// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by
//     java_cpp_enum.py
// From
//     ../../components/location/android/location_settings_dialog_outcome.h

package com.vccorp.components.location;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@IntDef({
    LocationSettingsDialogOutcome.GRANTED, LocationSettingsDialogOutcome.DENIED,
    LocationSettingsDialogOutcome.NO_PROMPT
})
@Retention(RetentionPolicy.SOURCE)
public @interface LocationSettingsDialogOutcome {
  /**
   * The user accepted the prompt and the system location setting has been flipped to granted.
   */
  int GRANTED = 1;
  /**
   * The user rejected the prompt and the system location setting has not been flipped.
   */
  int DENIED = 2;
  /**
   * The prompt could not be triggered. When CanPromptToEnableSystemLocationSetting() returns true,
   * this should only happen in exceptional circonstances, e.g. - In the case of a race condition
   * where the system location setting is flipped elsewhere before the prompt could be triggered; -
   * In the case where some of the features required to trigger a system location setting prompt
   * became unavailable or unresponsive after the response from
   * CanPromptToEnableSystemLocationSetting() was received.
   */
  int NO_PROMPT = 3;
}
