
// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by
//     java_cpp_enum.py
// From
//     ../../third_party/blink/public/platform/web_focus_type.h

package com.vccorp.blink_public.web;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@IntDef({
    WebFocusType.NONE, WebFocusType.FORWARD, WebFocusType.BACKWARD, WebFocusType.SPATIAL_NAVIGATION,
    WebFocusType.MOUSE, WebFocusType.ACCESS_KEY, WebFocusType.PAGE, WebFocusType.LAST
})
@Retention(RetentionPolicy.SOURCE)
public @interface WebFocusType {
  /**
   * Element::focus(), etc.
   */
  int NONE = 0;
  /**
   * Sequential navigation with TAB, or Shift + TAB.
   */
  int FORWARD = 1;
  int BACKWARD = 2;
  /**
   * Spatial navigation.
   */
  int SPATIAL_NAVIGATION = 3;
  /**
   * Mouse press
   */
  int MOUSE = 4;
  /**
   * Access key
   */
  int ACCESS_KEY = 5;
  /**
   * Re-focus by a page focus
   */
  int PAGE = 6;
  int LAST = 6;
}
