
// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by
//     java_cpp_enum.py
// From
//     ../../third_party/blink/public/web/web_context_menu_data.h

package com.vccorp.blink_public.web;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@IntDef({
    WebContextMenuMediaType.NONE, WebContextMenuMediaType.IMAGE, WebContextMenuMediaType.VIDEO,
    WebContextMenuMediaType.AUDIO, WebContextMenuMediaType.CANVAS, WebContextMenuMediaType.FILE,
    WebContextMenuMediaType.PLUGIN, WebContextMenuMediaType.LAST
})
@Retention(RetentionPolicy.SOURCE)
public @interface WebContextMenuMediaType {
  /**
   * No special node is in context.
   */
  int NONE = 0;
  /**
   * An image node is selected.
   */
  int IMAGE = 1;
  /**
   * A video node is selected.
   */
  int VIDEO = 2;
  /**
   * An audio node is selected.
   */
  int AUDIO = 3;
  /**
   * A canvas node is selected.
   */
  int CANVAS = 4;
  /**
   * A file node is selected.
   */
  int FILE = 5;
  /**
   * A plugin node is selected.
   */
  int PLUGIN = 6;
  int LAST = 6;
}
