
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/webdatabase/web_database.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class WebDatabase_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<WebDatabase, WebDatabase.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<WebDatabase, WebDatabase.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.WebDatabase";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, WebDatabase impl) {
            return new Stub(core, impl);
        }

        @Override
        public WebDatabase[] buildArray(int size) {
          return new WebDatabase[size];
        }
    };


    private static final int UPDATE_SIZE_ORDINAL = 0;

    private static final int CLOSE_IMMEDIATELY_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements WebDatabase.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void updateSize(
com.vccorp.url.mojom.Origin origin, com.vccorp.mojo_base.mojom.String16 name, long size) {

            WebDatabaseUpdateSizeParams _message = new WebDatabaseUpdateSizeParams();

            _message.origin = origin;

            _message.name = name;

            _message.size = size;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_SIZE_ORDINAL)));

        }


        @Override
        public void closeImmediately(
com.vccorp.url.mojom.Origin origin, com.vccorp.mojo_base.mojom.String16 name) {

            WebDatabaseCloseImmediatelyParams _message = new WebDatabaseCloseImmediatelyParams();

            _message.origin = origin;

            _message.name = name;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLOSE_IMMEDIATELY_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<WebDatabase> {

        Stub(com.vccorp.mojo.system.Core core, WebDatabase impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                WebDatabase_Internal.MANAGER, messageWithHeader);





                    case UPDATE_SIZE_ORDINAL: {

                        WebDatabaseUpdateSizeParams data =
                                WebDatabaseUpdateSizeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateSize(data.origin, data.name, data.size);
                        return true;
                    }





                    case CLOSE_IMMEDIATELY_ORDINAL: {

                        WebDatabaseCloseImmediatelyParams data =
                                WebDatabaseCloseImmediatelyParams.deserialize(messageWithHeader.getPayload());

                        getImpl().closeImmediately(data.origin, data.name);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), WebDatabase_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class WebDatabaseUpdateSizeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Origin origin;
        public com.vccorp.mojo_base.mojom.String16 name;
        public long size;

        private WebDatabaseUpdateSizeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebDatabaseUpdateSizeParams() {
            this(0);
        }

        public static WebDatabaseUpdateSizeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebDatabaseUpdateSizeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebDatabaseUpdateSizeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebDatabaseUpdateSizeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebDatabaseUpdateSizeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.name = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                    }
                    {
                        
                    result.size = decoder0.readLong(24);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.origin, 8, false);
            
            encoder0.encode(this.name, 16, false);
            
            encoder0.encode(this.size, 24);
        }
    }



    
    static final class WebDatabaseCloseImmediatelyParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Origin origin;
        public com.vccorp.mojo_base.mojom.String16 name;

        private WebDatabaseCloseImmediatelyParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebDatabaseCloseImmediatelyParams() {
            this(0);
        }

        public static WebDatabaseCloseImmediatelyParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebDatabaseCloseImmediatelyParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebDatabaseCloseImmediatelyParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebDatabaseCloseImmediatelyParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebDatabaseCloseImmediatelyParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.name = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.origin, 8, false);
            
            encoder0.encode(this.name, 16, false);
        }
    }



}
