
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class UserAgentMetadata extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String brand;
    public String fullVersion;
    public String majorVersion;
    public String platform;
    public String architecture;
    public String model;

    private UserAgentMetadata(int version) {
        super(STRUCT_SIZE, version);
    }

    public UserAgentMetadata() {
        this(0);
    }

    public static UserAgentMetadata deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static UserAgentMetadata deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static UserAgentMetadata decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        UserAgentMetadata result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new UserAgentMetadata(elementsOrVersion);
                {
                    
                result.brand = decoder0.readString(8, false);
                }
                {
                    
                result.fullVersion = decoder0.readString(16, false);
                }
                {
                    
                result.majorVersion = decoder0.readString(24, false);
                }
                {
                    
                result.platform = decoder0.readString(32, false);
                }
                {
                    
                result.architecture = decoder0.readString(40, false);
                }
                {
                    
                result.model = decoder0.readString(48, false);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.brand, 8, false);
        
        encoder0.encode(this.fullVersion, 16, false);
        
        encoder0.encode(this.majorVersion, 24, false);
        
        encoder0.encode(this.platform, 32, false);
        
        encoder0.encode(this.architecture, 40, false);
        
        encoder0.encode(this.model, 48, false);
    }
}