
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class UrlLoaderFactoryBundle extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.network.mojom.UrlLoaderFactory defaultFactory;
    public java.util.Map<String, com.vccorp.network.mojom.UrlLoaderFactory> schemeSpecificFactories;
    public java.util.Map<com.vccorp.url.mojom.Origin, com.vccorp.network.mojom.UrlLoaderFactory> initiatorSpecificFactories;
    public com.vccorp.network.mojom.UrlLoaderFactory appcacheFactory;
    public boolean bypassRedirectChecks;

    private UrlLoaderFactoryBundle(int version) {
        super(STRUCT_SIZE, version);
        this.bypassRedirectChecks = (boolean) false;
    }

    public UrlLoaderFactoryBundle() {
        this(0);
    }

    public static UrlLoaderFactoryBundle deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static UrlLoaderFactoryBundle deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static UrlLoaderFactoryBundle decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        UrlLoaderFactoryBundle result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new UrlLoaderFactoryBundle(elementsOrVersion);
                {
                    
                result.defaultFactory = decoder0.readServiceInterface(8, true, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                {
                    decoder1.readDataHeaderForMap();
                    String[] keys0;
                    com.vccorp.network.mojom.UrlLoaderFactory[] values0;
                    {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                        {
                            com.vccorp.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                            keys0 = new String[si2.elementsOrVersion];
                            for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                                
                                keys0[i2] = decoder2.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                            }
                        }
                    }
                    {
                        
                        values0 = decoder1.readServiceInterfaces(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, keys0.length, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
                    }
                    result.schemeSpecificFactories = new java.util.HashMap<String, com.vccorp.network.mojom.UrlLoaderFactory>();
                    for (int index0 = 0; index0 < keys0.length; ++index0) {
                        result.schemeSpecificFactories.put(keys0[index0],  values0[index0]);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                {
                    decoder1.readDataHeaderForMap();
                    com.vccorp.url.mojom.Origin[] keys0;
                    com.vccorp.network.mojom.UrlLoaderFactory[] values0;
                    {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                        {
                            com.vccorp.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                            keys0 = new com.vccorp.url.mojom.Origin[si2.elementsOrVersion];
                            for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                                
                                com.vccorp.mojo.bindings.Decoder decoder3 = decoder2.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                                keys0[i2] = com.vccorp.url.mojom.Origin.decode(decoder3);
                            }
                        }
                    }
                    {
                        
                        values0 = decoder1.readServiceInterfaces(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, keys0.length, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
                    }
                    result.initiatorSpecificFactories = new java.util.HashMap<com.vccorp.url.mojom.Origin, com.vccorp.network.mojom.UrlLoaderFactory>();
                    for (int index0 = 0; index0 < keys0.length; ++index0) {
                        result.initiatorSpecificFactories.put(keys0[index0],  values0[index0]);
                    }
                }
                }
                {
                    
                result.appcacheFactory = decoder0.readServiceInterface(32, true, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
                }
                {
                    
                result.bypassRedirectChecks = decoder0.readBoolean(40, 0);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.defaultFactory, 8, true, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
        
        if (this.schemeSpecificFactories == null) {
            encoder0.encodeNullPointer(16, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encoderForMap(16);
            int size0 = this.schemeSpecificFactories.size();
            String[] keys0 = new String[size0];
            com.vccorp.network.mojom.UrlLoaderFactory[] values0 = new com.vccorp.network.mojom.UrlLoaderFactory[size0];
            int index0 = 0;
            for (java.util.Map.Entry<String, com.vccorp.network.mojom.UrlLoaderFactory> entry0 : this.schemeSpecificFactories.entrySet()) {
                keys0[index0] = entry0.getKey();
                values0[index0] = entry0.getValue();
                ++index0;
            }
            
            {
                org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(keys0.length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i1 = 0; i1 < keys0.length; ++i1) {
                    
                    encoder2.encode(keys0[i1], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                }
            }
            
            encoder1.encode(values0, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
        }
        
        if (this.initiatorSpecificFactories == null) {
            encoder0.encodeNullPointer(24, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encoderForMap(24);
            int size0 = this.initiatorSpecificFactories.size();
            com.vccorp.url.mojom.Origin[] keys0 = new com.vccorp.url.mojom.Origin[size0];
            com.vccorp.network.mojom.UrlLoaderFactory[] values0 = new com.vccorp.network.mojom.UrlLoaderFactory[size0];
            int index0 = 0;
            for (java.util.Map.Entry<com.vccorp.url.mojom.Origin, com.vccorp.network.mojom.UrlLoaderFactory> entry0 : this.initiatorSpecificFactories.entrySet()) {
                keys0[index0] = entry0.getKey();
                values0[index0] = entry0.getValue();
                ++index0;
            }
            
            {
                org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(keys0.length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i1 = 0; i1 < keys0.length; ++i1) {
                    
                    encoder2.encode(keys0[i1], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                }
            }
            
            encoder1.encode(values0, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
        }
        
        encoder0.encode(this.appcacheFactory, 32, true, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
        
        encoder0.encode(this.bypassRedirectChecks, 40, 0);
    }
}