
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/input/input_messages.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class TextSuggestionBackend_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<TextSuggestionBackend, TextSuggestionBackend.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<TextSuggestionBackend, TextSuggestionBackend.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.TextSuggestionBackend";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, TextSuggestionBackend impl) {
            return new Stub(core, impl);
        }

        @Override
        public TextSuggestionBackend[] buildArray(int size) {
          return new TextSuggestionBackend[size];
        }
    };


    private static final int APPLY_SPELL_CHECK_SUGGESTION_ORDINAL = 0;

    private static final int APPLY_TEXT_SUGGESTION_ORDINAL = 1;

    private static final int DELETE_ACTIVE_SUGGESTION_RANGE_ORDINAL = 2;

    private static final int ON_NEW_WORD_ADDED_TO_DICTIONARY_ORDINAL = 3;

    private static final int ON_SUGGESTION_MENU_CLOSED_ORDINAL = 4;

    private static final int SUGGESTION_MENU_TIMEOUT_CALLBACK_ORDINAL = 5;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements TextSuggestionBackend.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void applySpellCheckSuggestion(
String suggestion) {

            TextSuggestionBackendApplySpellCheckSuggestionParams _message = new TextSuggestionBackendApplySpellCheckSuggestionParams();

            _message.suggestion = suggestion;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(APPLY_SPELL_CHECK_SUGGESTION_ORDINAL)));

        }


        @Override
        public void applyTextSuggestion(
int markerTag, int suggestionIndex) {

            TextSuggestionBackendApplyTextSuggestionParams _message = new TextSuggestionBackendApplyTextSuggestionParams();

            _message.markerTag = markerTag;

            _message.suggestionIndex = suggestionIndex;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(APPLY_TEXT_SUGGESTION_ORDINAL)));

        }


        @Override
        public void deleteActiveSuggestionRange(
) {

            TextSuggestionBackendDeleteActiveSuggestionRangeParams _message = new TextSuggestionBackendDeleteActiveSuggestionRangeParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DELETE_ACTIVE_SUGGESTION_RANGE_ORDINAL)));

        }


        @Override
        public void onNewWordAddedToDictionary(
String suggestion) {

            TextSuggestionBackendOnNewWordAddedToDictionaryParams _message = new TextSuggestionBackendOnNewWordAddedToDictionaryParams();

            _message.suggestion = suggestion;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_NEW_WORD_ADDED_TO_DICTIONARY_ORDINAL)));

        }


        @Override
        public void onSuggestionMenuClosed(
) {

            TextSuggestionBackendOnSuggestionMenuClosedParams _message = new TextSuggestionBackendOnSuggestionMenuClosedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SUGGESTION_MENU_CLOSED_ORDINAL)));

        }


        @Override
        public void suggestionMenuTimeoutCallback(
int maxNumberOfSuggestions) {

            TextSuggestionBackendSuggestionMenuTimeoutCallbackParams _message = new TextSuggestionBackendSuggestionMenuTimeoutCallbackParams();

            _message.maxNumberOfSuggestions = maxNumberOfSuggestions;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SUGGESTION_MENU_TIMEOUT_CALLBACK_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<TextSuggestionBackend> {

        Stub(com.vccorp.mojo.system.Core core, TextSuggestionBackend impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                TextSuggestionBackend_Internal.MANAGER, messageWithHeader);





                    case APPLY_SPELL_CHECK_SUGGESTION_ORDINAL: {

                        TextSuggestionBackendApplySpellCheckSuggestionParams data =
                                TextSuggestionBackendApplySpellCheckSuggestionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().applySpellCheckSuggestion(data.suggestion);
                        return true;
                    }





                    case APPLY_TEXT_SUGGESTION_ORDINAL: {

                        TextSuggestionBackendApplyTextSuggestionParams data =
                                TextSuggestionBackendApplyTextSuggestionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().applyTextSuggestion(data.markerTag, data.suggestionIndex);
                        return true;
                    }





                    case DELETE_ACTIVE_SUGGESTION_RANGE_ORDINAL: {

                        TextSuggestionBackendDeleteActiveSuggestionRangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().deleteActiveSuggestionRange();
                        return true;
                    }





                    case ON_NEW_WORD_ADDED_TO_DICTIONARY_ORDINAL: {

                        TextSuggestionBackendOnNewWordAddedToDictionaryParams data =
                                TextSuggestionBackendOnNewWordAddedToDictionaryParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onNewWordAddedToDictionary(data.suggestion);
                        return true;
                    }





                    case ON_SUGGESTION_MENU_CLOSED_ORDINAL: {

                        TextSuggestionBackendOnSuggestionMenuClosedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onSuggestionMenuClosed();
                        return true;
                    }





                    case SUGGESTION_MENU_TIMEOUT_CALLBACK_ORDINAL: {

                        TextSuggestionBackendSuggestionMenuTimeoutCallbackParams data =
                                TextSuggestionBackendSuggestionMenuTimeoutCallbackParams.deserialize(messageWithHeader.getPayload());

                        getImpl().suggestionMenuTimeoutCallback(data.maxNumberOfSuggestions);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), TextSuggestionBackend_Internal.MANAGER, messageWithHeader, receiver);














                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class TextSuggestionBackendApplySpellCheckSuggestionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String suggestion;

        private TextSuggestionBackendApplySpellCheckSuggestionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TextSuggestionBackendApplySpellCheckSuggestionParams() {
            this(0);
        }

        public static TextSuggestionBackendApplySpellCheckSuggestionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TextSuggestionBackendApplySpellCheckSuggestionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TextSuggestionBackendApplySpellCheckSuggestionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TextSuggestionBackendApplySpellCheckSuggestionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TextSuggestionBackendApplySpellCheckSuggestionParams(elementsOrVersion);
                    {
                        
                    result.suggestion = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.suggestion, 8, false);
        }
    }



    
    static final class TextSuggestionBackendApplyTextSuggestionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int markerTag;
        public int suggestionIndex;

        private TextSuggestionBackendApplyTextSuggestionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TextSuggestionBackendApplyTextSuggestionParams() {
            this(0);
        }

        public static TextSuggestionBackendApplyTextSuggestionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TextSuggestionBackendApplyTextSuggestionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TextSuggestionBackendApplyTextSuggestionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TextSuggestionBackendApplyTextSuggestionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TextSuggestionBackendApplyTextSuggestionParams(elementsOrVersion);
                    {
                        
                    result.markerTag = decoder0.readInt(8);
                    }
                    {
                        
                    result.suggestionIndex = decoder0.readInt(12);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.markerTag, 8);
            
            encoder0.encode(this.suggestionIndex, 12);
        }
    }



    
    static final class TextSuggestionBackendDeleteActiveSuggestionRangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private TextSuggestionBackendDeleteActiveSuggestionRangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TextSuggestionBackendDeleteActiveSuggestionRangeParams() {
            this(0);
        }

        public static TextSuggestionBackendDeleteActiveSuggestionRangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TextSuggestionBackendDeleteActiveSuggestionRangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TextSuggestionBackendDeleteActiveSuggestionRangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TextSuggestionBackendDeleteActiveSuggestionRangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TextSuggestionBackendDeleteActiveSuggestionRangeParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class TextSuggestionBackendOnNewWordAddedToDictionaryParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String suggestion;

        private TextSuggestionBackendOnNewWordAddedToDictionaryParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TextSuggestionBackendOnNewWordAddedToDictionaryParams() {
            this(0);
        }

        public static TextSuggestionBackendOnNewWordAddedToDictionaryParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TextSuggestionBackendOnNewWordAddedToDictionaryParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TextSuggestionBackendOnNewWordAddedToDictionaryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TextSuggestionBackendOnNewWordAddedToDictionaryParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TextSuggestionBackendOnNewWordAddedToDictionaryParams(elementsOrVersion);
                    {
                        
                    result.suggestion = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.suggestion, 8, false);
        }
    }



    
    static final class TextSuggestionBackendOnSuggestionMenuClosedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private TextSuggestionBackendOnSuggestionMenuClosedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TextSuggestionBackendOnSuggestionMenuClosedParams() {
            this(0);
        }

        public static TextSuggestionBackendOnSuggestionMenuClosedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TextSuggestionBackendOnSuggestionMenuClosedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TextSuggestionBackendOnSuggestionMenuClosedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TextSuggestionBackendOnSuggestionMenuClosedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TextSuggestionBackendOnSuggestionMenuClosedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class TextSuggestionBackendSuggestionMenuTimeoutCallbackParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int maxNumberOfSuggestions;

        private TextSuggestionBackendSuggestionMenuTimeoutCallbackParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TextSuggestionBackendSuggestionMenuTimeoutCallbackParams() {
            this(0);
        }

        public static TextSuggestionBackendSuggestionMenuTimeoutCallbackParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TextSuggestionBackendSuggestionMenuTimeoutCallbackParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TextSuggestionBackendSuggestionMenuTimeoutCallbackParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TextSuggestionBackendSuggestionMenuTimeoutCallbackParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TextSuggestionBackendSuggestionMenuTimeoutCallbackParams(elementsOrVersion);
                    {
                        
                    result.maxNumberOfSuggestions = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.maxNumberOfSuggestions, 8);
        }
    }



}
