
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/speech/speech_recognition_error_code.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class SpeechRecognitionErrorCode {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int NONE = 0;
    public static final int NO_SPEECH = 1; // NONE + 1
    public static final int ABORTED = 2; // NO_SPEECH + 1
    public static final int AUDIO_CAPTURE = 3; // ABORTED + 1
    public static final int NETWORK = 4; // AUDIO_CAPTURE + 1
    public static final int NOT_ALLOWED = 5; // NETWORK + 1
    public static final int SERVICE_NOT_ALLOWED = 6; // NOT_ALLOWED + 1
    public static final int BAD_GRAMMAR = 7; // SERVICE_NOT_ALLOWED + 1
    public static final int LANGUAGE_NOT_SUPPORTED = 8; // BAD_GRAMMAR + 1
    public static final int NO_MATCH = 9; // LANGUAGE_NOT_SUPPORTED + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 9;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private SpeechRecognitionErrorCode() {}
}