
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/worker/shared_worker_factory.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class SharedWorkerFactory_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<SharedWorkerFactory, SharedWorkerFactory.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<SharedWorkerFactory, SharedWorkerFactory.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.SharedWorkerFactory";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, SharedWorkerFactory impl) {
            return new Stub(core, impl);
        }

        @Override
        public SharedWorkerFactory[] buildArray(int size) {
          return new SharedWorkerFactory[size];
        }
    };


    private static final int CREATE_SHARED_WORKER_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements SharedWorkerFactory.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createSharedWorker(
SharedWorkerInfo info, boolean pauseOnStart, com.vccorp.mojo_base.mojom.UnguessableToken devtoolsWorkerToken, RendererPreferences rendererPreferences, com.vccorp.mojo.bindings.InterfaceRequest<RendererPreferenceWatcher> preferenceWatcherRequest, WorkerContentSettingsProxy contentSettings, ServiceWorkerProviderInfoForWorker serviceWorkerProviderInfo, int appcacheHostId, com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported mainScriptLoaderFactory, WorkerMainScriptLoadParams mainScriptLoadParams, UrlLoaderFactoryBundle subresourceLoaderFactories, ControllerServiceWorkerInfo controllerInfo, SharedWorkerHost host, com.vccorp.mojo.bindings.InterfaceRequest<SharedWorker> sharedWorker, com.vccorp.service_manager.mojom.InterfaceProvider interfaceProvider) {

            SharedWorkerFactoryCreateSharedWorkerParams _message = new SharedWorkerFactoryCreateSharedWorkerParams();

            _message.info = info;

            _message.pauseOnStart = pauseOnStart;

            _message.devtoolsWorkerToken = devtoolsWorkerToken;

            _message.rendererPreferences = rendererPreferences;

            _message.preferenceWatcherRequest = preferenceWatcherRequest;

            _message.contentSettings = contentSettings;

            _message.serviceWorkerProviderInfo = serviceWorkerProviderInfo;

            _message.appcacheHostId = appcacheHostId;

            _message.mainScriptLoaderFactory = mainScriptLoaderFactory;

            _message.mainScriptLoadParams = mainScriptLoadParams;

            _message.subresourceLoaderFactories = subresourceLoaderFactories;

            _message.controllerInfo = controllerInfo;

            _message.host = host;

            _message.sharedWorker = sharedWorker;

            _message.interfaceProvider = interfaceProvider;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_SHARED_WORKER_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<SharedWorkerFactory> {

        Stub(com.vccorp.mojo.system.Core core, SharedWorkerFactory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                SharedWorkerFactory_Internal.MANAGER, messageWithHeader);





                    case CREATE_SHARED_WORKER_ORDINAL: {

                        SharedWorkerFactoryCreateSharedWorkerParams data =
                                SharedWorkerFactoryCreateSharedWorkerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createSharedWorker(data.info, data.pauseOnStart, data.devtoolsWorkerToken, data.rendererPreferences, data.preferenceWatcherRequest, data.contentSettings, data.serviceWorkerProviderInfo, data.appcacheHostId, data.mainScriptLoaderFactory, data.mainScriptLoadParams, data.subresourceLoaderFactories, data.controllerInfo, data.host, data.sharedWorker, data.interfaceProvider);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), SharedWorkerFactory_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class SharedWorkerFactoryCreateSharedWorkerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 112;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(112, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public SharedWorkerInfo info;
        public boolean pauseOnStart;
        public com.vccorp.mojo_base.mojom.UnguessableToken devtoolsWorkerToken;
        public RendererPreferences rendererPreferences;
        public com.vccorp.mojo.bindings.InterfaceRequest<RendererPreferenceWatcher> preferenceWatcherRequest;
        public WorkerContentSettingsProxy contentSettings;
        public ServiceWorkerProviderInfoForWorker serviceWorkerProviderInfo;
        public int appcacheHostId;
        public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported mainScriptLoaderFactory;
        public WorkerMainScriptLoadParams mainScriptLoadParams;
        public UrlLoaderFactoryBundle subresourceLoaderFactories;
        public ControllerServiceWorkerInfo controllerInfo;
        public SharedWorkerHost host;
        public com.vccorp.mojo.bindings.InterfaceRequest<SharedWorker> sharedWorker;
        public com.vccorp.service_manager.mojom.InterfaceProvider interfaceProvider;

        private SharedWorkerFactoryCreateSharedWorkerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public SharedWorkerFactoryCreateSharedWorkerParams() {
            this(0);
        }

        public static SharedWorkerFactoryCreateSharedWorkerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static SharedWorkerFactoryCreateSharedWorkerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static SharedWorkerFactoryCreateSharedWorkerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            SharedWorkerFactoryCreateSharedWorkerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new SharedWorkerFactoryCreateSharedWorkerParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.info = SharedWorkerInfo.decode(decoder1);
                    }
                    {
                        
                    result.pauseOnStart = decoder0.readBoolean(16, 0);
                    }
                    {
                        
                    result.preferenceWatcherRequest = decoder0.readInterfaceRequest(20, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.devtoolsWorkerToken = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.rendererPreferences = RendererPreferences.decode(decoder1);
                    }
                    {
                        
                    result.contentSettings = decoder0.readServiceInterface(40, false, WorkerContentSettingsProxy.MANAGER);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                    result.serviceWorkerProviderInfo = ServiceWorkerProviderInfoForWorker.decode(decoder1);
                    }
                    {
                        
                    result.appcacheHostId = decoder0.readInt(56);
                    }
                    {
                        
                    result.mainScriptLoaderFactory = decoder0.readAssociatedServiceInterfaceNotSupported(60, true);
                    }
                    {
                        
                    result.sharedWorker = decoder0.readInterfaceRequest(68, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(72, true);
                    result.mainScriptLoadParams = WorkerMainScriptLoadParams.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(80, true);
                    result.subresourceLoaderFactories = UrlLoaderFactoryBundle.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(88, true);
                    result.controllerInfo = ControllerServiceWorkerInfo.decode(decoder1);
                    }
                    {
                        
                    result.host = decoder0.readServiceInterface(96, false, SharedWorkerHost.MANAGER);
                    }
                    {
                        
                    result.interfaceProvider = decoder0.readServiceInterface(104, false, com.vccorp.service_manager.mojom.InterfaceProvider.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.info, 8, false);
            
            encoder0.encode(this.pauseOnStart, 16, 0);
            
            encoder0.encode(this.preferenceWatcherRequest, 20, false);
            
            encoder0.encode(this.devtoolsWorkerToken, 24, false);
            
            encoder0.encode(this.rendererPreferences, 32, false);
            
            encoder0.encode(this.contentSettings, 40, false, WorkerContentSettingsProxy.MANAGER);
            
            encoder0.encode(this.serviceWorkerProviderInfo, 48, false);
            
            encoder0.encode(this.appcacheHostId, 56);
            
            encoder0.encode(this.mainScriptLoaderFactory, 60, true);
            
            encoder0.encode(this.sharedWorker, 68, false);
            
            encoder0.encode(this.mainScriptLoadParams, 72, true);
            
            encoder0.encode(this.subresourceLoaderFactories, 80, true);
            
            encoder0.encode(this.controllerInfo, 88, true);
            
            encoder0.encode(this.host, 96, false, SharedWorkerHost.MANAGER);
            
            encoder0.encode(this.interfaceProvider, 104, false, com.vccorp.service_manager.mojom.InterfaceProvider.MANAGER);
        }
    }



}
