
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/worker/shared_worker_connector.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class SharedWorkerConnector_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<SharedWorkerConnector, SharedWorkerConnector.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<SharedWorkerConnector, SharedWorkerConnector.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.SharedWorkerConnector";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, SharedWorkerConnector impl) {
            return new Stub(core, impl);
        }

        @Override
        public SharedWorkerConnector[] buildArray(int size) {
          return new SharedWorkerConnector[size];
        }
    };


    private static final int CONNECT_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements SharedWorkerConnector.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void connect(
SharedWorkerInfo info, SharedWorkerClient client, int creationContextType, com.vccorp.mojo.system.MessagePipeHandle messagePort, BlobUrlToken blobUrlToken) {

            SharedWorkerConnectorConnectParams _message = new SharedWorkerConnectorConnectParams();

            _message.info = info;

            _message.client = client;

            _message.creationContextType = creationContextType;

            _message.messagePort = messagePort;

            _message.blobUrlToken = blobUrlToken;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CONNECT_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<SharedWorkerConnector> {

        Stub(com.vccorp.mojo.system.Core core, SharedWorkerConnector impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                SharedWorkerConnector_Internal.MANAGER, messageWithHeader);





                    case CONNECT_ORDINAL: {

                        SharedWorkerConnectorConnectParams data =
                                SharedWorkerConnectorConnectParams.deserialize(messageWithHeader.getPayload());

                        getImpl().connect(data.info, data.client, data.creationContextType, data.messagePort, data.blobUrlToken);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), SharedWorkerConnector_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class SharedWorkerConnectorConnectParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public SharedWorkerInfo info;
        public SharedWorkerClient client;
        public int creationContextType;
        public com.vccorp.mojo.system.MessagePipeHandle messagePort;
        public BlobUrlToken blobUrlToken;

        private SharedWorkerConnectorConnectParams(int version) {
            super(STRUCT_SIZE, version);
            this.messagePort = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public SharedWorkerConnectorConnectParams() {
            this(0);
        }

        public static SharedWorkerConnectorConnectParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static SharedWorkerConnectorConnectParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static SharedWorkerConnectorConnectParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            SharedWorkerConnectorConnectParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new SharedWorkerConnectorConnectParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.info = SharedWorkerInfo.decode(decoder1);
                    }
                    {
                        
                    result.client = decoder0.readServiceInterface(16, false, SharedWorkerClient.MANAGER);
                    }
                    {
                        
                    result.creationContextType = decoder0.readInt(24);
                        SharedWorkerCreationContextType.validate(result.creationContextType);
                    }
                    {
                        
                    result.messagePort = decoder0.readMessagePipeHandle(28, false);
                    }
                    {
                        
                    result.blobUrlToken = decoder0.readServiceInterface(32, true, BlobUrlToken.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.info, 8, false);
            
            encoder0.encode(this.client, 16, false, SharedWorkerClient.MANAGER);
            
            encoder0.encode(this.creationContextType, 24);
            
            encoder0.encode(this.messagePort, 28, false);
            
            encoder0.encode(this.blobUrlToken, 32, true, BlobUrlToken.MANAGER);
        }
    }



}
