
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker_provider.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ServiceWorkerWorkerClientRegistry_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ServiceWorkerWorkerClientRegistry, ServiceWorkerWorkerClientRegistry.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ServiceWorkerWorkerClientRegistry, ServiceWorkerWorkerClientRegistry.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.ServiceWorkerWorkerClientRegistry";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ServiceWorkerWorkerClientRegistry impl) {
            return new Stub(core, impl);
        }

        @Override
        public ServiceWorkerWorkerClientRegistry[] buildArray(int size) {
          return new ServiceWorkerWorkerClientRegistry[size];
        }
    };


    private static final int REGISTER_WORKER_CLIENT_ORDINAL = 0;

    private static final int CLONE_WORKER_CLIENT_REGISTRY_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ServiceWorkerWorkerClientRegistry.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void registerWorkerClient(
ServiceWorkerWorkerClient client) {

            ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams _message = new ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams();

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REGISTER_WORKER_CLIENT_ORDINAL)));

        }


        @Override
        public void cloneWorkerClientRegistry(
com.vccorp.mojo.bindings.InterfaceRequest<ServiceWorkerWorkerClientRegistry> host) {

            ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams _message = new ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams();

            _message.host = host;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLONE_WORKER_CLIENT_REGISTRY_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ServiceWorkerWorkerClientRegistry> {

        Stub(com.vccorp.mojo.system.Core core, ServiceWorkerWorkerClientRegistry impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ServiceWorkerWorkerClientRegistry_Internal.MANAGER, messageWithHeader);





                    case REGISTER_WORKER_CLIENT_ORDINAL: {

                        ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams data =
                                ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams.deserialize(messageWithHeader.getPayload());

                        getImpl().registerWorkerClient(data.client);
                        return true;
                    }





                    case CLONE_WORKER_CLIENT_REGISTRY_ORDINAL: {

                        ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams data =
                                ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams.deserialize(messageWithHeader.getPayload());

                        getImpl().cloneWorkerClientRegistry(data.host);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ServiceWorkerWorkerClientRegistry_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ServiceWorkerWorkerClient client;

        private ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams() {
            this(0);
        }

        public static ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerWorkerClientRegistryRegisterWorkerClientParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readServiceInterface(8, false, ServiceWorkerWorkerClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false, ServiceWorkerWorkerClient.MANAGER);
        }
    }



    
    static final class ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<ServiceWorkerWorkerClientRegistry> host;

        private ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams() {
            this(0);
        }

        public static ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerWorkerClientRegistryCloneWorkerClientRegistryParams(elementsOrVersion);
                    {
                        
                    result.host = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.host, 8, false);
        }
    }



}
