
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker_registration.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ServiceWorkerRegistrationObjectInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 64;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(64, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public long registrationId;
    public com.vccorp.url.mojom.Url scope;
    public int updateViaCache;
    public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported hostPtrInfo;
    public com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported request;
    public ServiceWorkerObjectInfo installing;
    public ServiceWorkerObjectInfo waiting;
    public ServiceWorkerObjectInfo active;

    private ServiceWorkerRegistrationObjectInfo(int version) {
        super(STRUCT_SIZE, version);
        this.registrationId = (long) ServiceWorkerRegistrationConstants.INVALID_SERVICE_WORKER_REGISTRATION_ID;
    }

    public ServiceWorkerRegistrationObjectInfo() {
        this(0);
    }

    public static ServiceWorkerRegistrationObjectInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ServiceWorkerRegistrationObjectInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ServiceWorkerRegistrationObjectInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ServiceWorkerRegistrationObjectInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ServiceWorkerRegistrationObjectInfo(elementsOrVersion);
                {
                    
                result.registrationId = decoder0.readLong(8);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.scope = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                result.updateViaCache = decoder0.readInt(24);
                    ServiceWorkerUpdateViaCache.validate(result.updateViaCache);
                }
                {
                    
                result.hostPtrInfo = decoder0.readAssociatedServiceInterfaceNotSupported(28, false);
                }
                {
                    
                result.request = decoder0.readAssociatedInterfaceRequestNotSupported(36, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, true);
                result.installing = ServiceWorkerObjectInfo.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, true);
                result.waiting = ServiceWorkerObjectInfo.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, true);
                result.active = ServiceWorkerObjectInfo.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.registrationId, 8);
        
        encoder0.encode(this.scope, 16, false);
        
        encoder0.encode(this.updateViaCache, 24);
        
        encoder0.encode(this.hostPtrInfo, 28, false);
        
        encoder0.encode(this.request, 36, false);
        
        encoder0.encode(this.installing, 40, true);
        
        encoder0.encode(this.waiting, 48, true);
        
        encoder0.encode(this.active, 56, true);
    }
}