
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker_registration.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ServiceWorkerRegistrationObjectHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ServiceWorkerRegistrationObjectHost, ServiceWorkerRegistrationObjectHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ServiceWorkerRegistrationObjectHost, ServiceWorkerRegistrationObjectHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.ServiceWorkerRegistrationObjectHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ServiceWorkerRegistrationObjectHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public ServiceWorkerRegistrationObjectHost[] buildArray(int size) {
          return new ServiceWorkerRegistrationObjectHost[size];
        }
    };


    private static final int UPDATE_ORDINAL = 0;

    private static final int UNREGISTER_ORDINAL = 1;

    private static final int ENABLE_NAVIGATION_PRELOAD_ORDINAL = 2;

    private static final int GET_NAVIGATION_PRELOAD_STATE_ORDINAL = 3;

    private static final int SET_NAVIGATION_PRELOAD_HEADER_ORDINAL = 4;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ServiceWorkerRegistrationObjectHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void update(

UpdateResponse callback) {

            ServiceWorkerRegistrationObjectHostUpdateParams _message = new ServiceWorkerRegistrationObjectHostUpdateParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UPDATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerRegistrationObjectHostUpdateResponseParamsForwardToCallback(callback));

        }


        @Override
        public void unregister(

UnregisterResponse callback) {

            ServiceWorkerRegistrationObjectHostUnregisterParams _message = new ServiceWorkerRegistrationObjectHostUnregisterParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UNREGISTER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerRegistrationObjectHostUnregisterResponseParamsForwardToCallback(callback));

        }


        @Override
        public void enableNavigationPreload(
boolean enable, 
EnableNavigationPreloadResponse callback) {

            ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams _message = new ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams();

            _message.enable = enable;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENABLE_NAVIGATION_PRELOAD_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getNavigationPreloadState(

GetNavigationPreloadStateResponse callback) {

            ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams _message = new ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_NAVIGATION_PRELOAD_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setNavigationPreloadHeader(
String value, 
SetNavigationPreloadHeaderResponse callback) {

            ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams _message = new ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams();

            _message.value = value;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_NAVIGATION_PRELOAD_HEADER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ServiceWorkerRegistrationObjectHost> {

        Stub(com.vccorp.mojo.system.Core core, ServiceWorkerRegistrationObjectHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ServiceWorkerRegistrationObjectHost_Internal.MANAGER, messageWithHeader);












                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ServiceWorkerRegistrationObjectHost_Internal.MANAGER, messageWithHeader, receiver);







                    case UPDATE_ORDINAL: {

                        ServiceWorkerRegistrationObjectHostUpdateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().update(new ServiceWorkerRegistrationObjectHostUpdateResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case UNREGISTER_ORDINAL: {

                        ServiceWorkerRegistrationObjectHostUnregisterParams.deserialize(messageWithHeader.getPayload());

                        getImpl().unregister(new ServiceWorkerRegistrationObjectHostUnregisterResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ENABLE_NAVIGATION_PRELOAD_ORDINAL: {

                        ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams data =
                                ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams.deserialize(messageWithHeader.getPayload());

                        getImpl().enableNavigationPreload(data.enable, new ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_NAVIGATION_PRELOAD_STATE_ORDINAL: {

                        ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getNavigationPreloadState(new ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_NAVIGATION_PRELOAD_HEADER_ORDINAL: {

                        ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams data =
                                ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setNavigationPreloadHeader(data.value, new ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ServiceWorkerRegistrationObjectHostUpdateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerRegistrationObjectHostUpdateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostUpdateParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostUpdateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostUpdateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostUpdateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostUpdateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostUpdateParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostUpdateResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public String errorMsg;

        private ServiceWorkerRegistrationObjectHostUpdateResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostUpdateResponseParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostUpdateResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostUpdateResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostUpdateResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostUpdateResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostUpdateResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        ServiceWorkerErrorType.validate(result.error);
                    }
                    {
                        
                    result.errorMsg = decoder0.readString(16, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.errorMsg, 16, true);
        }
    }

    static class ServiceWorkerRegistrationObjectHostUpdateResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorkerRegistrationObjectHost.UpdateResponse mCallback;

        ServiceWorkerRegistrationObjectHostUpdateResponseParamsForwardToCallback(ServiceWorkerRegistrationObjectHost.UpdateResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(UPDATE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerRegistrationObjectHostUpdateResponseParams response = ServiceWorkerRegistrationObjectHostUpdateResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.errorMsg);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerRegistrationObjectHostUpdateResponseParamsProxyToResponder implements ServiceWorkerRegistrationObjectHost.UpdateResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerRegistrationObjectHostUpdateResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, String errorMsg) {
            ServiceWorkerRegistrationObjectHostUpdateResponseParams _response = new ServiceWorkerRegistrationObjectHostUpdateResponseParams();

            _response.error = error;

            _response.errorMsg = errorMsg;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UPDATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostUnregisterParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerRegistrationObjectHostUnregisterParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostUnregisterParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostUnregisterParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostUnregisterParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostUnregisterParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostUnregisterParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostUnregisterParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostUnregisterResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public String errorMsg;

        private ServiceWorkerRegistrationObjectHostUnregisterResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostUnregisterResponseParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostUnregisterResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostUnregisterResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostUnregisterResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostUnregisterResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostUnregisterResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        ServiceWorkerErrorType.validate(result.error);
                    }
                    {
                        
                    result.errorMsg = decoder0.readString(16, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.errorMsg, 16, true);
        }
    }

    static class ServiceWorkerRegistrationObjectHostUnregisterResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorkerRegistrationObjectHost.UnregisterResponse mCallback;

        ServiceWorkerRegistrationObjectHostUnregisterResponseParamsForwardToCallback(ServiceWorkerRegistrationObjectHost.UnregisterResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(UNREGISTER_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerRegistrationObjectHostUnregisterResponseParams response = ServiceWorkerRegistrationObjectHostUnregisterResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.errorMsg);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerRegistrationObjectHostUnregisterResponseParamsProxyToResponder implements ServiceWorkerRegistrationObjectHost.UnregisterResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerRegistrationObjectHostUnregisterResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, String errorMsg) {
            ServiceWorkerRegistrationObjectHostUnregisterResponseParams _response = new ServiceWorkerRegistrationObjectHostUnregisterResponseParams();

            _response.error = error;

            _response.errorMsg = errorMsg;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UNREGISTER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean enable;

        private ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostEnableNavigationPreloadParams(elementsOrVersion);
                    {
                        
                    result.enable = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.enable, 8, 0);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public String errorMsg;

        private ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        ServiceWorkerErrorType.validate(result.error);
                    }
                    {
                        
                    result.errorMsg = decoder0.readString(16, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.errorMsg, 16, true);
        }
    }

    static class ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorkerRegistrationObjectHost.EnableNavigationPreloadResponse mCallback;

        ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParamsForwardToCallback(ServiceWorkerRegistrationObjectHost.EnableNavigationPreloadResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ENABLE_NAVIGATION_PRELOAD_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams response = ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.errorMsg);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParamsProxyToResponder implements ServiceWorkerRegistrationObjectHost.EnableNavigationPreloadResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, String errorMsg) {
            ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams _response = new ServiceWorkerRegistrationObjectHostEnableNavigationPreloadResponseParams();

            _response.error = error;

            _response.errorMsg = errorMsg;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENABLE_NAVIGATION_PRELOAD_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public String errorMsg;
        public NavigationPreloadState state;

        private ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        ServiceWorkerErrorType.validate(result.error);
                    }
                    {
                        
                    result.errorMsg = decoder0.readString(16, true);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.state = NavigationPreloadState.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.errorMsg, 16, true);
            
            encoder0.encode(this.state, 24, true);
        }
    }

    static class ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorkerRegistrationObjectHost.GetNavigationPreloadStateResponse mCallback;

        ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParamsForwardToCallback(ServiceWorkerRegistrationObjectHost.GetNavigationPreloadStateResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_NAVIGATION_PRELOAD_STATE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams response = ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.errorMsg, response.state);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParamsProxyToResponder implements ServiceWorkerRegistrationObjectHost.GetNavigationPreloadStateResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, String errorMsg, NavigationPreloadState state) {
            ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams _response = new ServiceWorkerRegistrationObjectHostGetNavigationPreloadStateResponseParams();

            _response.error = error;

            _response.errorMsg = errorMsg;

            _response.state = state;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_NAVIGATION_PRELOAD_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String value;

        private ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderParams(elementsOrVersion);
                    {
                        
                    result.value = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.value, 8, false);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public String errorMsg;

        private ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        ServiceWorkerErrorType.validate(result.error);
                    }
                    {
                        
                    result.errorMsg = decoder0.readString(16, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.errorMsg, 16, true);
        }
    }

    static class ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ServiceWorkerRegistrationObjectHost.SetNavigationPreloadHeaderResponse mCallback;

        ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParamsForwardToCallback(ServiceWorkerRegistrationObjectHost.SetNavigationPreloadHeaderResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_NAVIGATION_PRELOAD_HEADER_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams response = ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.errorMsg);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParamsProxyToResponder implements ServiceWorkerRegistrationObjectHost.SetNavigationPreloadHeaderResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, String errorMsg) {
            ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams _response = new ServiceWorkerRegistrationObjectHostSetNavigationPreloadHeaderResponseParams();

            _response.error = error;

            _response.errorMsg = errorMsg;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_NAVIGATION_PRELOAD_HEADER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
