
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/webauthn/authenticator.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class PublicKeyCredentialCreationOptions extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 80;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(80, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public PublicKeyCredentialRpEntity relyingParty;
    public PublicKeyCredentialUserEntity user;
    public byte[] challenge;
    public PublicKeyCredentialParameters[] publicKeyParameters;
    public com.vccorp.mojo_base.mojom.TimeDelta adjustedTimeout;
    public PublicKeyCredentialDescriptor[] excludeCredentials;
    public AuthenticatorSelectionCriteria authenticatorSelection;
    public int attestation;
    public CableRegistration cableRegistrationData;
    public boolean hmacCreateSecret;
    public boolean userVerificationMethods;

    private PublicKeyCredentialCreationOptions(int version) {
        super(STRUCT_SIZE, version);
    }

    public PublicKeyCredentialCreationOptions() {
        this(0);
    }

    public static PublicKeyCredentialCreationOptions deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static PublicKeyCredentialCreationOptions deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static PublicKeyCredentialCreationOptions decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        PublicKeyCredentialCreationOptions result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new PublicKeyCredentialCreationOptions(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.relyingParty = PublicKeyCredentialRpEntity.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.user = PublicKeyCredentialUserEntity.decode(decoder1);
                }
                {
                    
                result.challenge = decoder0.readBytes(24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.publicKeyParameters = new PublicKeyCredentialParameters[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.publicKeyParameters[i1] = PublicKeyCredentialParameters.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.adjustedTimeout = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.excludeCredentials = new PublicKeyCredentialDescriptor[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.excludeCredentials[i1] = PublicKeyCredentialDescriptor.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, true);
                result.authenticatorSelection = AuthenticatorSelectionCriteria.decode(decoder1);
                }
                {
                    
                result.attestation = decoder0.readInt(64);
                    AttestationConveyancePreference.validate(result.attestation);
                }
                {
                    
                result.hmacCreateSecret = decoder0.readBoolean(68, 0);
                }
                {
                    
                result.userVerificationMethods = decoder0.readBoolean(68, 1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(72, true);
                result.cableRegistrationData = CableRegistration.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.relyingParty, 8, false);
        
        encoder0.encode(this.user, 16, false);
        
        encoder0.encode(this.challenge, 24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        if (this.publicKeyParameters == null) {
            encoder0.encodeNullPointer(32, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.publicKeyParameters.length, 32, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.publicKeyParameters.length; ++i0) {
                
                encoder1.encode(this.publicKeyParameters[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.adjustedTimeout, 40, false);
        
        if (this.excludeCredentials == null) {
            encoder0.encodeNullPointer(48, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.excludeCredentials.length, 48, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.excludeCredentials.length; ++i0) {
                
                encoder1.encode(this.excludeCredentials[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.authenticatorSelection, 56, true);
        
        encoder0.encode(this.attestation, 64);
        
        encoder0.encode(this.hmacCreateSecret, 68, 0);
        
        encoder0.encode(this.userVerificationMethods, 68, 1);
        
        encoder0.encode(this.cableRegistrationData, 72, true);
    }
}