
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/presentation/presentation.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class PresentationConnectionMessage extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int Message = 0;
        public static final int Data = 1;
    };
    private String mMessage;
    private byte[] mData;

    public void setMessage(String message) {
        this.mTag = Tag.Message;
        this.mMessage = message;
    }

    public String getMessage() {
        assert this.mTag == Tag.Message;
        return this.mMessage;
    }

    public void setData(byte[] data) {
        this.mTag = Tag.Data;
        this.mData = data;
    }

    public byte[] getData() {
        assert this.mTag == Tag.Data;
        return this.mData;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.Message: {
                
                encoder0.encode(this.mMessage, offset + 8, false);
                break;
            }
            case Tag.Data: {
                
                encoder0.encode(this.mData, offset + 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static PresentationConnectionMessage deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final PresentationConnectionMessage decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        PresentationConnectionMessage result = new PresentationConnectionMessage();
        switch (dataHeader.elementsOrVersion) {
            case Tag.Message: {
                
                result.mMessage = decoder0.readString(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mTag = Tag.Message;
                break;
            }
            case Tag.Data: {
                
                result.mData = decoder0.readBytes(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.mTag = Tag.Data;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}