
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/feature_policy/feature_policy.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class PolicyValueData extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int NullValue = 0;
        public static final int BoolValue = 1;
        public static final int DecDoubleValue = 2;
    };
    private boolean mNullValue;
    private boolean mBoolValue;
    private double mDecDoubleValue;

    public void setNullValue(boolean nullValue) {
        this.mTag = Tag.NullValue;
        this.mNullValue = nullValue;
    }

    public boolean getNullValue() {
        assert this.mTag == Tag.NullValue;
        return this.mNullValue;
    }

    public void setBoolValue(boolean boolValue) {
        this.mTag = Tag.BoolValue;
        this.mBoolValue = boolValue;
    }

    public boolean getBoolValue() {
        assert this.mTag == Tag.BoolValue;
        return this.mBoolValue;
    }

    public void setDecDoubleValue(double decDoubleValue) {
        this.mTag = Tag.DecDoubleValue;
        this.mDecDoubleValue = decDoubleValue;
    }

    public double getDecDoubleValue() {
        assert this.mTag == Tag.DecDoubleValue;
        return this.mDecDoubleValue;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.NullValue: {
                
                encoder0.encode(this.mNullValue, offset + 8, 0);
                break;
            }
            case Tag.BoolValue: {
                
                encoder0.encode(this.mBoolValue, offset + 8, 0);
                break;
            }
            case Tag.DecDoubleValue: {
                
                encoder0.encode(this.mDecDoubleValue, offset + 8);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static PolicyValueData deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final PolicyValueData decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        PolicyValueData result = new PolicyValueData();
        switch (dataHeader.elementsOrVersion) {
            case Tag.NullValue: {
                
                result.mNullValue = decoder0.readBoolean(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, 0);
                result.mTag = Tag.NullValue;
                break;
            }
            case Tag.BoolValue: {
                
                result.mBoolValue = decoder0.readBoolean(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, 0);
                result.mTag = Tag.BoolValue;
                break;
            }
            case Tag.DecDoubleValue: {
                
                result.mDecDoubleValue = decoder0.readDouble(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE);
                result.mTag = Tag.DecDoubleValue;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}