
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/mediastream/media_stream.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class MediaStreamType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int MEDIA_NO_SERVICE = 0;
    public static final int MEDIA_DEVICE_AUDIO_CAPTURE = 1; // MEDIA_NO_SERVICE + 1
    public static final int MEDIA_DEVICE_VIDEO_CAPTURE = 2; // MEDIA_DEVICE_AUDIO_CAPTURE + 1
    public static final int MEDIA_GUM_TAB_AUDIO_CAPTURE = 3; // MEDIA_DEVICE_VIDEO_CAPTURE + 1
    public static final int MEDIA_GUM_TAB_VIDEO_CAPTURE = 4; // MEDIA_GUM_TAB_AUDIO_CAPTURE + 1
    public static final int MEDIA_GUM_DESKTOP_VIDEO_CAPTURE = 5; // MEDIA_GUM_TAB_VIDEO_CAPTURE + 1
    public static final int MEDIA_GUM_DESKTOP_AUDIO_CAPTURE = 6; // MEDIA_GUM_DESKTOP_VIDEO_CAPTURE + 1
    public static final int MEDIA_DISPLAY_VIDEO_CAPTURE = 7; // MEDIA_GUM_DESKTOP_AUDIO_CAPTURE + 1
    public static final int MEDIA_DISPLAY_AUDIO_CAPTURE = 8; // MEDIA_DISPLAY_VIDEO_CAPTURE + 1
    public static final int NUM_MEDIA_TYPES = 9; // MEDIA_DISPLAY_AUDIO_CAPTURE + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 9;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private MediaStreamType() {}
}