
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/mediastream/media_stream.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class MediaStreamRequestResult {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int OK = 0;
    public static final int PERMISSION_DENIED = 1; // OK + 1
    public static final int PERMISSION_DISMISSED = 2; // PERMISSION_DENIED + 1
    public static final int INVALID_STATE = 3; // PERMISSION_DISMISSED + 1
    public static final int NO_HARDWARE = 4; // INVALID_STATE + 1
    public static final int INVALID_SECURITY_ORIGIN = 5; // NO_HARDWARE + 1
    public static final int TAB_CAPTURE_FAILURE = 6; // INVALID_SECURITY_ORIGIN + 1
    public static final int SCREEN_CAPTURE_FAILURE = 7; // TAB_CAPTURE_FAILURE + 1
    public static final int CAPTURE_FAILURE = 8; // SCREEN_CAPTURE_FAILURE + 1
    public static final int CONSTRAINT_NOT_SATISFIED = 9; // CAPTURE_FAILURE + 1
    public static final int TRACK_START_FAILURE_AUDIO = 10; // CONSTRAINT_NOT_SATISFIED + 1
    public static final int TRACK_START_FAILURE_VIDEO = 11; // TRACK_START_FAILURE_AUDIO + 1
    public static final int NOT_SUPPORTED = 12; // TRACK_START_FAILURE_VIDEO + 1
    public static final int FAILED_DUE_TO_SHUTDOWN = 13; // NOT_SUPPORTED + 1
    public static final int KILL_SWITCH_ON = 14; // FAILED_DUE_TO_SHUTDOWN + 1
    public static final int SYSTEM_PERMISSION_DENIED = 15; // KILL_SWITCH_ON + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 15;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private MediaStreamRequestResult() {}
}