
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/mediastream/media_stream.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MediaStreamDeviceObserver_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MediaStreamDeviceObserver, MediaStreamDeviceObserver.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MediaStreamDeviceObserver, MediaStreamDeviceObserver.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.MediaStreamDeviceObserver";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MediaStreamDeviceObserver impl) {
            return new Stub(core, impl);
        }

        @Override
        public MediaStreamDeviceObserver[] buildArray(int size) {
          return new MediaStreamDeviceObserver[size];
        }
    };


    private static final int ON_DEVICE_STOPPED_ORDINAL = 0;

    private static final int ON_DEVICE_CHANGED_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MediaStreamDeviceObserver.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onDeviceStopped(
String label, MediaStreamDevice device) {

            MediaStreamDeviceObserverOnDeviceStoppedParams _message = new MediaStreamDeviceObserverOnDeviceStoppedParams();

            _message.label = label;

            _message.device = device;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_DEVICE_STOPPED_ORDINAL)));

        }


        @Override
        public void onDeviceChanged(
String label, MediaStreamDevice oldDevice, MediaStreamDevice newDevice) {

            MediaStreamDeviceObserverOnDeviceChangedParams _message = new MediaStreamDeviceObserverOnDeviceChangedParams();

            _message.label = label;

            _message.oldDevice = oldDevice;

            _message.newDevice = newDevice;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_DEVICE_CHANGED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MediaStreamDeviceObserver> {

        Stub(com.vccorp.mojo.system.Core core, MediaStreamDeviceObserver impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaStreamDeviceObserver_Internal.MANAGER, messageWithHeader);





                    case ON_DEVICE_STOPPED_ORDINAL: {

                        MediaStreamDeviceObserverOnDeviceStoppedParams data =
                                MediaStreamDeviceObserverOnDeviceStoppedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onDeviceStopped(data.label, data.device);
                        return true;
                    }





                    case ON_DEVICE_CHANGED_ORDINAL: {

                        MediaStreamDeviceObserverOnDeviceChangedParams data =
                                MediaStreamDeviceObserverOnDeviceChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onDeviceChanged(data.label, data.oldDevice, data.newDevice);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaStreamDeviceObserver_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MediaStreamDeviceObserverOnDeviceStoppedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String label;
        public MediaStreamDevice device;

        private MediaStreamDeviceObserverOnDeviceStoppedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDeviceObserverOnDeviceStoppedParams() {
            this(0);
        }

        public static MediaStreamDeviceObserverOnDeviceStoppedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDeviceObserverOnDeviceStoppedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDeviceObserverOnDeviceStoppedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDeviceObserverOnDeviceStoppedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDeviceObserverOnDeviceStoppedParams(elementsOrVersion);
                    {
                        
                    result.label = decoder0.readString(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.device = MediaStreamDevice.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.label, 8, false);
            
            encoder0.encode(this.device, 16, false);
        }
    }



    
    static final class MediaStreamDeviceObserverOnDeviceChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String label;
        public MediaStreamDevice oldDevice;
        public MediaStreamDevice newDevice;

        private MediaStreamDeviceObserverOnDeviceChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaStreamDeviceObserverOnDeviceChangedParams() {
            this(0);
        }

        public static MediaStreamDeviceObserverOnDeviceChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaStreamDeviceObserverOnDeviceChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaStreamDeviceObserverOnDeviceChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaStreamDeviceObserverOnDeviceChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaStreamDeviceObserverOnDeviceChangedParams(elementsOrVersion);
                    {
                        
                    result.label = decoder0.readString(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.oldDevice = MediaStreamDevice.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.newDevice = MediaStreamDevice.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.label, 8, false);
            
            encoder0.encode(this.oldDevice, 16, false);
            
            encoder0.encode(this.newDevice, 24, false);
        }
    }



}
