
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/mediasession/media_session.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MediaSessionService_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MediaSessionService, MediaSessionService.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MediaSessionService, MediaSessionService.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.MediaSessionService";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MediaSessionService impl) {
            return new Stub(core, impl);
        }

        @Override
        public MediaSessionService[] buildArray(int size) {
          return new MediaSessionService[size];
        }
    };


    private static final int SET_CLIENT_ORDINAL = 0;

    private static final int SET_PLAYBACK_STATE_ORDINAL = 1;

    private static final int SET_METADATA_ORDINAL = 2;

    private static final int ENABLE_ACTION_ORDINAL = 3;

    private static final int DISABLE_ACTION_ORDINAL = 4;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MediaSessionService.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void setClient(
MediaSessionClient client) {

            MediaSessionServiceSetClientParams _message = new MediaSessionServiceSetClientParams();

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_CLIENT_ORDINAL)));

        }


        @Override
        public void setPlaybackState(
int state) {

            MediaSessionServiceSetPlaybackStateParams _message = new MediaSessionServiceSetPlaybackStateParams();

            _message.state = state;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_PLAYBACK_STATE_ORDINAL)));

        }


        @Override
        public void setMetadata(
SpecMediaMetadata metadata) {

            MediaSessionServiceSetMetadataParams _message = new MediaSessionServiceSetMetadataParams();

            _message.metadata = metadata;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_METADATA_ORDINAL)));

        }


        @Override
        public void enableAction(
int action) {

            MediaSessionServiceEnableActionParams _message = new MediaSessionServiceEnableActionParams();

            _message.action = action;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ENABLE_ACTION_ORDINAL)));

        }


        @Override
        public void disableAction(
int action) {

            MediaSessionServiceDisableActionParams _message = new MediaSessionServiceDisableActionParams();

            _message.action = action;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DISABLE_ACTION_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MediaSessionService> {

        Stub(com.vccorp.mojo.system.Core core, MediaSessionService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaSessionService_Internal.MANAGER, messageWithHeader);





                    case SET_CLIENT_ORDINAL: {

                        MediaSessionServiceSetClientParams data =
                                MediaSessionServiceSetClientParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setClient(data.client);
                        return true;
                    }





                    case SET_PLAYBACK_STATE_ORDINAL: {

                        MediaSessionServiceSetPlaybackStateParams data =
                                MediaSessionServiceSetPlaybackStateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setPlaybackState(data.state);
                        return true;
                    }





                    case SET_METADATA_ORDINAL: {

                        MediaSessionServiceSetMetadataParams data =
                                MediaSessionServiceSetMetadataParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setMetadata(data.metadata);
                        return true;
                    }





                    case ENABLE_ACTION_ORDINAL: {

                        MediaSessionServiceEnableActionParams data =
                                MediaSessionServiceEnableActionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().enableAction(data.action);
                        return true;
                    }





                    case DISABLE_ACTION_ORDINAL: {

                        MediaSessionServiceDisableActionParams data =
                                MediaSessionServiceDisableActionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().disableAction(data.action);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaSessionService_Internal.MANAGER, messageWithHeader, receiver);












                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MediaSessionServiceSetClientParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public MediaSessionClient client;

        private MediaSessionServiceSetClientParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionServiceSetClientParams() {
            this(0);
        }

        public static MediaSessionServiceSetClientParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionServiceSetClientParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionServiceSetClientParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionServiceSetClientParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionServiceSetClientParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readServiceInterface(8, false, MediaSessionClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false, MediaSessionClient.MANAGER);
        }
    }



    
    static final class MediaSessionServiceSetPlaybackStateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int state;

        private MediaSessionServiceSetPlaybackStateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionServiceSetPlaybackStateParams() {
            this(0);
        }

        public static MediaSessionServiceSetPlaybackStateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionServiceSetPlaybackStateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionServiceSetPlaybackStateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionServiceSetPlaybackStateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionServiceSetPlaybackStateParams(elementsOrVersion);
                    {
                        
                    result.state = decoder0.readInt(8);
                        MediaSessionPlaybackState.validate(result.state);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.state, 8);
        }
    }



    
    static final class MediaSessionServiceSetMetadataParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public SpecMediaMetadata metadata;

        private MediaSessionServiceSetMetadataParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionServiceSetMetadataParams() {
            this(0);
        }

        public static MediaSessionServiceSetMetadataParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionServiceSetMetadataParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionServiceSetMetadataParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionServiceSetMetadataParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionServiceSetMetadataParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.metadata = SpecMediaMetadata.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.metadata, 8, true);
        }
    }



    
    static final class MediaSessionServiceEnableActionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int action;

        private MediaSessionServiceEnableActionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionServiceEnableActionParams() {
            this(0);
        }

        public static MediaSessionServiceEnableActionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionServiceEnableActionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionServiceEnableActionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionServiceEnableActionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionServiceEnableActionParams(elementsOrVersion);
                    {
                        
                    result.action = decoder0.readInt(8);
                        com.vccorp.media_session.mojom.MediaSessionAction.validate(result.action);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.action, 8);
        }
    }



    
    static final class MediaSessionServiceDisableActionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int action;

        private MediaSessionServiceDisableActionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaSessionServiceDisableActionParams() {
            this(0);
        }

        public static MediaSessionServiceDisableActionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaSessionServiceDisableActionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaSessionServiceDisableActionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaSessionServiceDisableActionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaSessionServiceDisableActionParams(elementsOrVersion);
                    {
                        
                    result.action = decoder0.readInt(8);
                        com.vccorp.media_session.mojom.MediaSessionAction.validate(result.action);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.action, 8);
        }
    }



}
