
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/manifest/manifest.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class Manifest_ extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 112;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(112, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.mojo_base.mojom.String16 name;
    public com.vccorp.mojo_base.mojom.String16 shortName;
    public com.vccorp.url.mojom.Url startUrl;
    public int display;
    public int orientation;
    public ManifestImageResource[] icons;
    public ManifestShareTarget shareTarget;
    public ManifestFileFilter[] fileHandler;
    public ManifestRelatedApplication[] relatedApplications;
    public boolean preferRelatedApplications;
    public boolean hasThemeColor;
    public int themeColor;
    public boolean hasBackgroundColor;
    public int backgroundColor;
    public com.vccorp.url.mojom.Url splashScreenUrl;
    public com.vccorp.mojo_base.mojom.String16 gcmSenderId;
    public com.vccorp.url.mojom.Url scope;

    private Manifest_(int version) {
        super(STRUCT_SIZE, version);
    }

    public Manifest_() {
        this(0);
    }

    public static Manifest_ deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static Manifest_ deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static Manifest_ decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        Manifest_ result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new Manifest_(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                result.name = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.shortName = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                result.startUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                result.display = decoder0.readInt(32);
                    DisplayMode.validate(result.display);
                }
                {
                    
                result.orientation = decoder0.readInt(36);
                    com.vccorp.device.mojom.ScreenOrientationLockType.validate(result.orientation);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, true);
                if (decoder1 == null) {
                    result.icons = null;
                } else {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.icons = new ManifestImageResource[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.icons[i1] = ManifestImageResource.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, true);
                result.shareTarget = ManifestShareTarget.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, true);
                if (decoder1 == null) {
                    result.fileHandler = null;
                } else {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.fileHandler = new ManifestFileFilter[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.fileHandler[i1] = ManifestFileFilter.decode(decoder2);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, true);
                if (decoder1 == null) {
                    result.relatedApplications = null;
                } else {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.relatedApplications = new ManifestRelatedApplication[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.relatedApplications[i1] = ManifestRelatedApplication.decode(decoder2);
                    }
                }
                }
                {
                    
                result.preferRelatedApplications = decoder0.readBoolean(72, 0);
                }
                {
                    
                result.hasThemeColor = decoder0.readBoolean(72, 1);
                }
                {
                    
                result.hasBackgroundColor = decoder0.readBoolean(72, 2);
                }
                {
                    
                result.themeColor = decoder0.readInt(76);
                }
                {
                    
                result.backgroundColor = decoder0.readInt(80);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(88, true);
                result.splashScreenUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(96, true);
                result.gcmSenderId = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(104, true);
                result.scope = com.vccorp.url.mojom.Url.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.name, 8, true);
        
        encoder0.encode(this.shortName, 16, true);
        
        encoder0.encode(this.startUrl, 24, true);
        
        encoder0.encode(this.display, 32);
        
        encoder0.encode(this.orientation, 36);
        
        if (this.icons == null) {
            encoder0.encodeNullPointer(40, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.icons.length, 40, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.icons.length; ++i0) {
                
                encoder1.encode(this.icons[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.shareTarget, 48, true);
        
        if (this.fileHandler == null) {
            encoder0.encodeNullPointer(56, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.fileHandler.length, 56, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.fileHandler.length; ++i0) {
                
                encoder1.encode(this.fileHandler[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        if (this.relatedApplications == null) {
            encoder0.encodeNullPointer(64, true);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.relatedApplications.length, 64, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.relatedApplications.length; ++i0) {
                
                encoder1.encode(this.relatedApplications[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.preferRelatedApplications, 72, 0);
        
        encoder0.encode(this.hasThemeColor, 72, 1);
        
        encoder0.encode(this.hasBackgroundColor, 72, 2);
        
        encoder0.encode(this.themeColor, 76);
        
        encoder0.encode(this.backgroundColor, 80);
        
        encoder0.encode(this.splashScreenUrl, 88, true);
        
        encoder0.encode(this.gcmSenderId, 96, true);
        
        encoder0.encode(this.scope, 104, true);
    }
}