
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/embedded_worker.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class EmbeddedWorkerStartParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 128;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(128, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public long serviceWorkerVersionId;
    public com.vccorp.url.mojom.Url scope;
    public com.vccorp.url.mojom.Url scriptUrl;
    public int scriptType;
    public String userAgent;
    public int workerDevtoolsAgentRouteId;
    public com.vccorp.mojo_base.mojom.UnguessableToken devtoolsWorkerToken;
    public boolean pauseAfterDownload;
    public boolean waitForDebugger;
    public boolean isInstalled;
    public int v8CacheOptions;
    public RendererPreferences rendererPreferences;
    public com.vccorp.mojo.bindings.InterfaceRequest<ServiceWorker> serviceWorkerRequest;
    public com.vccorp.mojo.bindings.InterfaceRequest<ControllerServiceWorker> controllerRequest;
    public ServiceWorkerInstalledScriptsInfo installedScriptsInfo;
    public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported instanceHost;
    public ServiceWorkerProviderInfoForStartWorker providerInfo;
    public WorkerContentSettingsProxy contentSettingsProxy;
    public com.vccorp.mojo.bindings.InterfaceRequest<RendererPreferenceWatcher> preferenceWatcherRequest;
    public UrlLoaderFactoryBundle subresourceLoaderFactories;

    private EmbeddedWorkerStartParams(int version) {
        super(STRUCT_SIZE, version);
    }

    public EmbeddedWorkerStartParams() {
        this(0);
    }

    public static EmbeddedWorkerStartParams deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static EmbeddedWorkerStartParams deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static EmbeddedWorkerStartParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        EmbeddedWorkerStartParams result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new EmbeddedWorkerStartParams(elementsOrVersion);
                {
                    
                result.serviceWorkerVersionId = decoder0.readLong(8);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.scope = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.scriptUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                result.scriptType = decoder0.readInt(32);
                    ScriptType.validate(result.scriptType);
                }
                {
                    
                result.workerDevtoolsAgentRouteId = decoder0.readInt(36);
                }
                {
                    
                result.userAgent = decoder0.readString(40, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                result.devtoolsWorkerToken = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                }
                {
                    
                result.pauseAfterDownload = decoder0.readBoolean(56, 0);
                }
                {
                    
                result.waitForDebugger = decoder0.readBoolean(56, 1);
                }
                {
                    
                result.isInstalled = decoder0.readBoolean(56, 2);
                }
                {
                    
                result.v8CacheOptions = decoder0.readInt(60);
                    V8CacheOptions.validate(result.v8CacheOptions);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, false);
                result.rendererPreferences = RendererPreferences.decode(decoder1);
                }
                {
                    
                result.serviceWorkerRequest = decoder0.readInterfaceRequest(72, false);
                }
                {
                    
                result.controllerRequest = decoder0.readInterfaceRequest(76, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(80, true);
                result.installedScriptsInfo = ServiceWorkerInstalledScriptsInfo.decode(decoder1);
                }
                {
                    
                result.instanceHost = decoder0.readAssociatedServiceInterfaceNotSupported(88, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(96, false);
                result.providerInfo = ServiceWorkerProviderInfoForStartWorker.decode(decoder1);
                }
                {
                    
                result.contentSettingsProxy = decoder0.readServiceInterface(104, false, WorkerContentSettingsProxy.MANAGER);
                }
                {
                    
                result.preferenceWatcherRequest = decoder0.readInterfaceRequest(112, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(120, true);
                result.subresourceLoaderFactories = UrlLoaderFactoryBundle.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.serviceWorkerVersionId, 8);
        
        encoder0.encode(this.scope, 16, false);
        
        encoder0.encode(this.scriptUrl, 24, false);
        
        encoder0.encode(this.scriptType, 32);
        
        encoder0.encode(this.workerDevtoolsAgentRouteId, 36);
        
        encoder0.encode(this.userAgent, 40, false);
        
        encoder0.encode(this.devtoolsWorkerToken, 48, false);
        
        encoder0.encode(this.pauseAfterDownload, 56, 0);
        
        encoder0.encode(this.waitForDebugger, 56, 1);
        
        encoder0.encode(this.isInstalled, 56, 2);
        
        encoder0.encode(this.v8CacheOptions, 60);
        
        encoder0.encode(this.rendererPreferences, 64, false);
        
        encoder0.encode(this.serviceWorkerRequest, 72, false);
        
        encoder0.encode(this.controllerRequest, 76, false);
        
        encoder0.encode(this.installedScriptsInfo, 80, true);
        
        encoder0.encode(this.instanceHost, 88, false);
        
        encoder0.encode(this.providerInfo, 96, false);
        
        encoder0.encode(this.contentSettingsProxy, 104, false, WorkerContentSettingsProxy.MANAGER);
        
        encoder0.encode(this.preferenceWatcherRequest, 112, false);
        
        encoder0.encode(this.subresourceLoaderFactories, 120, true);
    }
}