
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/oom_intervention/oom_intervention.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class DetectionArgs extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public long blinkWorkloadThreshold;
    public long privateFootprintThreshold;
    public long swapThreshold;
    public long virtualMemoryThresold;

    private DetectionArgs(int version) {
        super(STRUCT_SIZE, version);
    }

    public DetectionArgs() {
        this(0);
    }

    public static DetectionArgs deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static DetectionArgs deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static DetectionArgs decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        DetectionArgs result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new DetectionArgs(elementsOrVersion);
                {
                    
                result.blinkWorkloadThreshold = decoder0.readLong(8);
                }
                {
                    
                result.privateFootprintThreshold = decoder0.readLong(16);
                }
                {
                    
                result.swapThreshold = decoder0.readLong(24);
                }
                {
                    
                result.virtualMemoryThresold = decoder0.readLong(32);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.blinkWorkloadThreshold, 8);
        
        encoder0.encode(this.privateFootprintThreshold, 16);
        
        encoder0.encode(this.swapThreshold, 24);
        
        encoder0.encode(this.virtualMemoryThresold, 32);
    }
}