
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class DedicatedWorkerHostFactory_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<DedicatedWorkerHostFactory, DedicatedWorkerHostFactory.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<DedicatedWorkerHostFactory, DedicatedWorkerHostFactory.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.DedicatedWorkerHostFactory";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, DedicatedWorkerHostFactory impl) {
            return new Stub(core, impl);
        }

        @Override
        public DedicatedWorkerHostFactory[] buildArray(int size) {
          return new DedicatedWorkerHostFactory[size];
        }
    };


    private static final int CREATE_WORKER_HOST_ORDINAL = 0;

    private static final int CREATE_WORKER_HOST_AND_START_SCRIPT_LOAD_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements DedicatedWorkerHostFactory.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createWorkerHost(
com.vccorp.url.mojom.Origin origin, com.vccorp.mojo.bindings.InterfaceRequest<com.vccorp.service_manager.mojom.InterfaceProvider> workerInterfaceProvider) {

            DedicatedWorkerHostFactoryCreateWorkerHostParams _message = new DedicatedWorkerHostFactoryCreateWorkerHostParams();

            _message.origin = origin;

            _message.workerInterfaceProvider = workerInterfaceProvider;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_WORKER_HOST_ORDINAL)));

        }


        @Override
        public void createWorkerHostAndStartScriptLoad(
com.vccorp.url.mojom.Url scriptUrl, com.vccorp.url.mojom.Origin origin, BlobUrlToken blobUrlToken, DedicatedWorkerHostFactoryClient client) {

            DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams _message = new DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams();

            _message.scriptUrl = scriptUrl;

            _message.origin = origin;

            _message.blobUrlToken = blobUrlToken;

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_WORKER_HOST_AND_START_SCRIPT_LOAD_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<DedicatedWorkerHostFactory> {

        Stub(com.vccorp.mojo.system.Core core, DedicatedWorkerHostFactory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                DedicatedWorkerHostFactory_Internal.MANAGER, messageWithHeader);





                    case CREATE_WORKER_HOST_ORDINAL: {

                        DedicatedWorkerHostFactoryCreateWorkerHostParams data =
                                DedicatedWorkerHostFactoryCreateWorkerHostParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createWorkerHost(data.origin, data.workerInterfaceProvider);
                        return true;
                    }





                    case CREATE_WORKER_HOST_AND_START_SCRIPT_LOAD_ORDINAL: {

                        DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams data =
                                DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createWorkerHostAndStartScriptLoad(data.scriptUrl, data.origin, data.blobUrlToken, data.client);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), DedicatedWorkerHostFactory_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class DedicatedWorkerHostFactoryCreateWorkerHostParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Origin origin;
        public com.vccorp.mojo.bindings.InterfaceRequest<com.vccorp.service_manager.mojom.InterfaceProvider> workerInterfaceProvider;

        private DedicatedWorkerHostFactoryCreateWorkerHostParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DedicatedWorkerHostFactoryCreateWorkerHostParams() {
            this(0);
        }

        public static DedicatedWorkerHostFactoryCreateWorkerHostParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DedicatedWorkerHostFactoryCreateWorkerHostParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DedicatedWorkerHostFactoryCreateWorkerHostParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DedicatedWorkerHostFactoryCreateWorkerHostParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DedicatedWorkerHostFactoryCreateWorkerHostParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    result.workerInterfaceProvider = decoder0.readInterfaceRequest(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.origin, 8, false);
            
            encoder0.encode(this.workerInterfaceProvider, 16, false);
        }
    }



    
    static final class DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url scriptUrl;
        public com.vccorp.url.mojom.Origin origin;
        public BlobUrlToken blobUrlToken;
        public DedicatedWorkerHostFactoryClient client;

        private DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams() {
            this(0);
        }

        public static DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DedicatedWorkerHostFactoryCreateWorkerHostAndStartScriptLoadParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.scriptUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    result.blobUrlToken = decoder0.readServiceInterface(24, true, BlobUrlToken.MANAGER);
                    }
                    {
                        
                    result.client = decoder0.readServiceInterface(32, false, DedicatedWorkerHostFactoryClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.scriptUrl, 8, false);
            
            encoder0.encode(this.origin, 16, false);
            
            encoder0.encode(this.blobUrlToken, 24, true, BlobUrlToken.MANAGER);
            
            encoder0.encode(this.client, 32, false, DedicatedWorkerHostFactoryClient.MANAGER);
        }
    }



}
