
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/blob/data_element.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class DataElement extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int Bytes = 0;
        public static final int File = 1;
        public static final int FileFilesystem = 2;
        public static final int Blob = 3;
    };
    private DataElementBytes mBytes;
    private DataElementFile mFile;
    private DataElementFilesystemUrl mFileFilesystem;
    private DataElementBlob mBlob;

    public void setBytes(DataElementBytes bytes) {
        this.mTag = Tag.Bytes;
        this.mBytes = bytes;
    }

    public DataElementBytes getBytes() {
        assert this.mTag == Tag.Bytes;
        return this.mBytes;
    }

    public void setFile(DataElementFile file) {
        this.mTag = Tag.File;
        this.mFile = file;
    }

    public DataElementFile getFile() {
        assert this.mTag == Tag.File;
        return this.mFile;
    }

    public void setFileFilesystem(DataElementFilesystemUrl fileFilesystem) {
        this.mTag = Tag.FileFilesystem;
        this.mFileFilesystem = fileFilesystem;
    }

    public DataElementFilesystemUrl getFileFilesystem() {
        assert this.mTag == Tag.FileFilesystem;
        return this.mFileFilesystem;
    }

    public void setBlob(DataElementBlob blob) {
        this.mTag = Tag.Blob;
        this.mBlob = blob;
    }

    public DataElementBlob getBlob() {
        assert this.mTag == Tag.Blob;
        return this.mBlob;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.Bytes: {
                
                encoder0.encode(this.mBytes, offset + 8, false);
                break;
            }
            case Tag.File: {
                
                encoder0.encode(this.mFile, offset + 8, false);
                break;
            }
            case Tag.FileFilesystem: {
                
                encoder0.encode(this.mFileFilesystem, offset + 8, false);
                break;
            }
            case Tag.Blob: {
                
                encoder0.encode(this.mBlob, offset + 8, false);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static DataElement deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final DataElement decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        DataElement result = new DataElement();
        switch (dataHeader.elementsOrVersion) {
            case Tag.Bytes: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mBytes = DataElementBytes.decode(decoder1);
                result.mTag = Tag.Bytes;
                break;
            }
            case Tag.File: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mFile = DataElementFile.decode(decoder1);
                result.mTag = Tag.File;
                break;
            }
            case Tag.FileFilesystem: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mFileFilesystem = DataElementFilesystemUrl.decode(decoder1);
                result.mTag = Tag.FileFilesystem;
                break;
            }
            case Tag.Blob: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mBlob = DataElementBlob.decode(decoder1);
                result.mTag = Tag.Blob;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}