
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/credentialmanager/credential_manager.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class CredentialManagerError {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int SUCCESS = 0;
    public static final int PENDING_REQUEST = 1; // SUCCESS + 1
    public static final int PASSWORD_STORE_UNAVAILABLE = 2; // PENDING_REQUEST + 1
    public static final int NOT_ALLOWED = 3; // PASSWORD_STORE_UNAVAILABLE + 1
    public static final int INVALID_DOMAIN = 4; // NOT_ALLOWED + 1
    public static final int CREDENTIAL_EXCLUDED = 5; // INVALID_DOMAIN + 1
    public static final int CREDENTIAL_NOT_RECOGNIZED = 6; // CREDENTIAL_EXCLUDED + 1
    public static final int NOT_IMPLEMENTED = 7; // CREDENTIAL_NOT_RECOGNIZED + 1
    public static final int NOT_FOCUSED = 8; // NOT_IMPLEMENTED + 1
    public static final int RESIDENT_CREDENTIALS_UNSUPPORTED = 9; // NOT_FOCUSED + 1
    public static final int ANDROID_ALGORITHM_UNSUPPORTED = 10; // RESIDENT_CREDENTIALS_UNSUPPORTED + 1
    public static final int ANDROID_EMPTY_ALLOW_CREDENTIALS = 11; // ANDROID_ALGORITHM_UNSUPPORTED + 1
    public static final int ANDROID_NOT_SUPPORTED_ERROR = 12; // ANDROID_EMPTY_ALLOW_CREDENTIALS + 1
    public static final int ANDROID_USER_VERIFICATION_UNSUPPORTED = 13; // ANDROID_NOT_SUPPORTED_ERROR + 1
    public static final int UNKNOWN = 14; // ANDROID_USER_VERIFICATION_UNSUPPORTED + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 14;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private CredentialManagerError() {}
}