
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/controller_service_worker.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ControllerServiceWorkerInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int mode;
    public ControllerServiceWorker endpoint;
    public String clientId;
    public com.vccorp.mojo_base.mojom.UnguessableToken fetchRequestWindowId;
    public ServiceWorkerObjectInfo objectInfo;
    public int[] usedFeatures;

    private ControllerServiceWorkerInfo(int version) {
        super(STRUCT_SIZE, version);
        this.mode = (int) ControllerServiceWorkerMode.NO_CONTROLLER;
    }

    public ControllerServiceWorkerInfo() {
        this(0);
    }

    public static ControllerServiceWorkerInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ControllerServiceWorkerInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ControllerServiceWorkerInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ControllerServiceWorkerInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ControllerServiceWorkerInfo(elementsOrVersion);
                {
                    
                result.mode = decoder0.readInt(8);
                    ControllerServiceWorkerMode.validate(result.mode);
                }
                {
                    
                result.endpoint = decoder0.readServiceInterface(12, true, ControllerServiceWorker.MANAGER);
                }
                {
                    
                result.clientId = decoder0.readString(24, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
                result.fetchRequestWindowId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, true);
                result.objectInfo = ServiceWorkerObjectInfo.decode(decoder1);
                }
                {
                    
                result.usedFeatures = decoder0.readInts(48, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.usedFeatures.length; ++i0) {
                        WebFeature.validate(result.usedFeatures[i0]);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.mode, 8);
        
        encoder0.encode(this.endpoint, 12, true, ControllerServiceWorker.MANAGER);
        
        encoder0.encode(this.clientId, 24, false);
        
        encoder0.encode(this.fetchRequestWindowId, 32, true);
        
        encoder0.encode(this.objectInfo, 40, true);
        
        encoder0.encode(this.usedFeatures, 48, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
    }
}