
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/background_fetch/background_fetch.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class BackgroundFetchService_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<BackgroundFetchService, BackgroundFetchService.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<BackgroundFetchService, BackgroundFetchService.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.BackgroundFetchService";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, BackgroundFetchService impl) {
            return new Stub(core, impl);
        }

        @Override
        public BackgroundFetchService[] buildArray(int size) {
          return new BackgroundFetchService[size];
        }
    };


    private static final int FETCH_ORDINAL = 0;

    private static final int GET_REGISTRATION_ORDINAL = 1;

    private static final int GET_DEVELOPER_IDS_ORDINAL = 2;

    private static final int GET_ICON_DISPLAY_SIZE_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements BackgroundFetchService.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void fetch(
long serviceWorkerRegistrationId, String developerId, FetchApiRequest[] requests, BackgroundFetchOptions options, com.vccorp.skia.mojom.Bitmap icon, BackgroundFetchUkmData ukmData,
FetchResponse callback) {

            BackgroundFetchServiceFetchParams _message = new BackgroundFetchServiceFetchParams();

            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;

            _message.developerId = developerId;

            _message.requests = requests;

            _message.options = options;

            _message.icon = icon;

            _message.ukmData = ukmData;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    FETCH_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundFetchServiceFetchResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getRegistration(
long serviceWorkerRegistrationId, String developerId, 
GetRegistrationResponse callback) {

            BackgroundFetchServiceGetRegistrationParams _message = new BackgroundFetchServiceGetRegistrationParams();

            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;

            _message.developerId = developerId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_REGISTRATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundFetchServiceGetRegistrationResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getDeveloperIds(
long serviceWorkerRegistrationId, 
GetDeveloperIdsResponse callback) {

            BackgroundFetchServiceGetDeveloperIdsParams _message = new BackgroundFetchServiceGetDeveloperIdsParams();

            _message.serviceWorkerRegistrationId = serviceWorkerRegistrationId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_DEVELOPER_IDS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundFetchServiceGetDeveloperIdsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getIconDisplaySize(

GetIconDisplaySizeResponse callback) {

            BackgroundFetchServiceGetIconDisplaySizeParams _message = new BackgroundFetchServiceGetIconDisplaySizeParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_ICON_DISPLAY_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BackgroundFetchServiceGetIconDisplaySizeResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<BackgroundFetchService> {

        Stub(com.vccorp.mojo.system.Core core, BackgroundFetchService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                BackgroundFetchService_Internal.MANAGER, messageWithHeader);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), BackgroundFetchService_Internal.MANAGER, messageWithHeader, receiver);







                    case FETCH_ORDINAL: {

                        BackgroundFetchServiceFetchParams data =
                                BackgroundFetchServiceFetchParams.deserialize(messageWithHeader.getPayload());

                        getImpl().fetch(data.serviceWorkerRegistrationId, data.developerId, data.requests, data.options, data.icon, data.ukmData, new BackgroundFetchServiceFetchResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_REGISTRATION_ORDINAL: {

                        BackgroundFetchServiceGetRegistrationParams data =
                                BackgroundFetchServiceGetRegistrationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getRegistration(data.serviceWorkerRegistrationId, data.developerId, new BackgroundFetchServiceGetRegistrationResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_DEVELOPER_IDS_ORDINAL: {

                        BackgroundFetchServiceGetDeveloperIdsParams data =
                                BackgroundFetchServiceGetDeveloperIdsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getDeveloperIds(data.serviceWorkerRegistrationId, new BackgroundFetchServiceGetDeveloperIdsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_ICON_DISPLAY_SIZE_ORDINAL: {

                        BackgroundFetchServiceGetIconDisplaySizeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getIconDisplaySize(new BackgroundFetchServiceGetIconDisplaySizeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class BackgroundFetchServiceFetchParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 56;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long serviceWorkerRegistrationId;
        public String developerId;
        public FetchApiRequest[] requests;
        public BackgroundFetchOptions options;
        public com.vccorp.skia.mojom.Bitmap icon;
        public BackgroundFetchUkmData ukmData;

        private BackgroundFetchServiceFetchParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchServiceFetchParams() {
            this(0);
        }

        public static BackgroundFetchServiceFetchParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchServiceFetchParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchServiceFetchParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchServiceFetchParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchServiceFetchParams(elementsOrVersion);
                    {
                        
                    result.serviceWorkerRegistrationId = decoder0.readLong(8);
                    }
                    {
                        
                    result.developerId = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.requests = new FetchApiRequest[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.requests[i1] = FetchApiRequest.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.options = BackgroundFetchOptions.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, true);
                    result.icon = com.vccorp.skia.mojom.Bitmap.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                    result.ukmData = BackgroundFetchUkmData.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerRegistrationId, 8);
            
            encoder0.encode(this.developerId, 16, false);
            
            if (this.requests == null) {
                encoder0.encodeNullPointer(24, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.requests.length, 24, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.requests.length; ++i0) {
                    
                    encoder1.encode(this.requests[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.options, 32, false);
            
            encoder0.encode(this.icon, 40, true);
            
            encoder0.encode(this.ukmData, 48, false);
        }
    }



    
    static final class BackgroundFetchServiceFetchResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public BackgroundFetchRegistration registration;

        private BackgroundFetchServiceFetchResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchServiceFetchResponseParams() {
            this(0);
        }

        public static BackgroundFetchServiceFetchResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchServiceFetchResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchServiceFetchResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchServiceFetchResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchServiceFetchResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        BackgroundFetchError.validate(result.error);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.registration = BackgroundFetchRegistration.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.registration, 16, true);
        }
    }

    static class BackgroundFetchServiceFetchResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BackgroundFetchService.FetchResponse mCallback;

        BackgroundFetchServiceFetchResponseParamsForwardToCallback(BackgroundFetchService.FetchResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(FETCH_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BackgroundFetchServiceFetchResponseParams response = BackgroundFetchServiceFetchResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.registration);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundFetchServiceFetchResponseParamsProxyToResponder implements BackgroundFetchService.FetchResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundFetchServiceFetchResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, BackgroundFetchRegistration registration) {
            BackgroundFetchServiceFetchResponseParams _response = new BackgroundFetchServiceFetchResponseParams();

            _response.error = error;

            _response.registration = registration;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    FETCH_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BackgroundFetchServiceGetRegistrationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long serviceWorkerRegistrationId;
        public String developerId;

        private BackgroundFetchServiceGetRegistrationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchServiceGetRegistrationParams() {
            this(0);
        }

        public static BackgroundFetchServiceGetRegistrationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchServiceGetRegistrationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchServiceGetRegistrationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchServiceGetRegistrationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchServiceGetRegistrationParams(elementsOrVersion);
                    {
                        
                    result.serviceWorkerRegistrationId = decoder0.readLong(8);
                    }
                    {
                        
                    result.developerId = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerRegistrationId, 8);
            
            encoder0.encode(this.developerId, 16, false);
        }
    }



    
    static final class BackgroundFetchServiceGetRegistrationResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public BackgroundFetchRegistration registration;

        private BackgroundFetchServiceGetRegistrationResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchServiceGetRegistrationResponseParams() {
            this(0);
        }

        public static BackgroundFetchServiceGetRegistrationResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchServiceGetRegistrationResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchServiceGetRegistrationResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchServiceGetRegistrationResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchServiceGetRegistrationResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        BackgroundFetchError.validate(result.error);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.registration = BackgroundFetchRegistration.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            encoder0.encode(this.registration, 16, true);
        }
    }

    static class BackgroundFetchServiceGetRegistrationResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BackgroundFetchService.GetRegistrationResponse mCallback;

        BackgroundFetchServiceGetRegistrationResponseParamsForwardToCallback(BackgroundFetchService.GetRegistrationResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_REGISTRATION_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BackgroundFetchServiceGetRegistrationResponseParams response = BackgroundFetchServiceGetRegistrationResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.registration);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundFetchServiceGetRegistrationResponseParamsProxyToResponder implements BackgroundFetchService.GetRegistrationResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundFetchServiceGetRegistrationResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, BackgroundFetchRegistration registration) {
            BackgroundFetchServiceGetRegistrationResponseParams _response = new BackgroundFetchServiceGetRegistrationResponseParams();

            _response.error = error;

            _response.registration = registration;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_REGISTRATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BackgroundFetchServiceGetDeveloperIdsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long serviceWorkerRegistrationId;

        private BackgroundFetchServiceGetDeveloperIdsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchServiceGetDeveloperIdsParams() {
            this(0);
        }

        public static BackgroundFetchServiceGetDeveloperIdsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchServiceGetDeveloperIdsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchServiceGetDeveloperIdsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchServiceGetDeveloperIdsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchServiceGetDeveloperIdsParams(elementsOrVersion);
                    {
                        
                    result.serviceWorkerRegistrationId = decoder0.readLong(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerRegistrationId, 8);
        }
    }



    
    static final class BackgroundFetchServiceGetDeveloperIdsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;
        public String[] developerIds;

        private BackgroundFetchServiceGetDeveloperIdsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchServiceGetDeveloperIdsResponseParams() {
            this(0);
        }

        public static BackgroundFetchServiceGetDeveloperIdsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchServiceGetDeveloperIdsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchServiceGetDeveloperIdsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchServiceGetDeveloperIdsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchServiceGetDeveloperIdsResponseParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        BackgroundFetchError.validate(result.error);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.developerIds = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.developerIds[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
            
            if (this.developerIds == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.developerIds.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.developerIds.length; ++i0) {
                    
                    encoder1.encode(this.developerIds[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class BackgroundFetchServiceGetDeveloperIdsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BackgroundFetchService.GetDeveloperIdsResponse mCallback;

        BackgroundFetchServiceGetDeveloperIdsResponseParamsForwardToCallback(BackgroundFetchService.GetDeveloperIdsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_DEVELOPER_IDS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BackgroundFetchServiceGetDeveloperIdsResponseParams response = BackgroundFetchServiceGetDeveloperIdsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.error, response.developerIds);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundFetchServiceGetDeveloperIdsResponseParamsProxyToResponder implements BackgroundFetchService.GetDeveloperIdsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundFetchServiceGetDeveloperIdsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer error, String[] developerIds) {
            BackgroundFetchServiceGetDeveloperIdsResponseParams _response = new BackgroundFetchServiceGetDeveloperIdsResponseParams();

            _response.error = error;

            _response.developerIds = developerIds;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_DEVELOPER_IDS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BackgroundFetchServiceGetIconDisplaySizeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BackgroundFetchServiceGetIconDisplaySizeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchServiceGetIconDisplaySizeParams() {
            this(0);
        }

        public static BackgroundFetchServiceGetIconDisplaySizeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchServiceGetIconDisplaySizeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchServiceGetIconDisplaySizeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchServiceGetIconDisplaySizeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchServiceGetIconDisplaySizeParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BackgroundFetchServiceGetIconDisplaySizeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.gfx.mojom.Size iconSizePixels;

        private BackgroundFetchServiceGetIconDisplaySizeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchServiceGetIconDisplaySizeResponseParams() {
            this(0);
        }

        public static BackgroundFetchServiceGetIconDisplaySizeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchServiceGetIconDisplaySizeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchServiceGetIconDisplaySizeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchServiceGetIconDisplaySizeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchServiceGetIconDisplaySizeResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.iconSizePixels = com.vccorp.gfx.mojom.Size.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.iconSizePixels, 8, false);
        }
    }

    static class BackgroundFetchServiceGetIconDisplaySizeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BackgroundFetchService.GetIconDisplaySizeResponse mCallback;

        BackgroundFetchServiceGetIconDisplaySizeResponseParamsForwardToCallback(BackgroundFetchService.GetIconDisplaySizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_ICON_DISPLAY_SIZE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BackgroundFetchServiceGetIconDisplaySizeResponseParams response = BackgroundFetchServiceGetIconDisplaySizeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.iconSizePixels);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BackgroundFetchServiceGetIconDisplaySizeResponseParamsProxyToResponder implements BackgroundFetchService.GetIconDisplaySizeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BackgroundFetchServiceGetIconDisplaySizeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.gfx.mojom.Size iconSizePixels) {
            BackgroundFetchServiceGetIconDisplaySizeResponseParams _response = new BackgroundFetchServiceGetIconDisplaySizeResponseParams();

            _response.iconSizePixels = iconSizePixels;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_ICON_DISPLAY_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
