
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/background_fetch/background_fetch.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class BackgroundFetchRegistrationObserver_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<BackgroundFetchRegistrationObserver, BackgroundFetchRegistrationObserver.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<BackgroundFetchRegistrationObserver, BackgroundFetchRegistrationObserver.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.BackgroundFetchRegistrationObserver";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, BackgroundFetchRegistrationObserver impl) {
            return new Stub(core, impl);
        }

        @Override
        public BackgroundFetchRegistrationObserver[] buildArray(int size) {
          return new BackgroundFetchRegistrationObserver[size];
        }
    };


    private static final int ON_PROGRESS_ORDINAL = 0;

    private static final int ON_RECORDS_UNAVAILABLE_ORDINAL = 1;

    private static final int ON_REQUEST_COMPLETED_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements BackgroundFetchRegistrationObserver.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onProgress(
long uploadTotal, long uploaded, long downloadTotal, long downloaded, int result, int failureReason) {

            BackgroundFetchRegistrationObserverOnProgressParams _message = new BackgroundFetchRegistrationObserverOnProgressParams();

            _message.uploadTotal = uploadTotal;

            _message.uploaded = uploaded;

            _message.downloadTotal = downloadTotal;

            _message.downloaded = downloaded;

            _message.result = result;

            _message.failureReason = failureReason;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_PROGRESS_ORDINAL)));

        }


        @Override
        public void onRecordsUnavailable(
) {

            BackgroundFetchRegistrationObserverOnRecordsUnavailableParams _message = new BackgroundFetchRegistrationObserverOnRecordsUnavailableParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_RECORDS_UNAVAILABLE_ORDINAL)));

        }


        @Override
        public void onRequestCompleted(
FetchApiRequest request, FetchApiResponse response) {

            BackgroundFetchRegistrationObserverOnRequestCompletedParams _message = new BackgroundFetchRegistrationObserverOnRequestCompletedParams();

            _message.request = request;

            _message.response = response;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_REQUEST_COMPLETED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<BackgroundFetchRegistrationObserver> {

        Stub(com.vccorp.mojo.system.Core core, BackgroundFetchRegistrationObserver impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                BackgroundFetchRegistrationObserver_Internal.MANAGER, messageWithHeader);





                    case ON_PROGRESS_ORDINAL: {

                        BackgroundFetchRegistrationObserverOnProgressParams data =
                                BackgroundFetchRegistrationObserverOnProgressParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onProgress(data.uploadTotal, data.uploaded, data.downloadTotal, data.downloaded, data.result, data.failureReason);
                        return true;
                    }





                    case ON_RECORDS_UNAVAILABLE_ORDINAL: {

                        BackgroundFetchRegistrationObserverOnRecordsUnavailableParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onRecordsUnavailable();
                        return true;
                    }





                    case ON_REQUEST_COMPLETED_ORDINAL: {

                        BackgroundFetchRegistrationObserverOnRequestCompletedParams data =
                                BackgroundFetchRegistrationObserverOnRequestCompletedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onRequestCompleted(data.request, data.response);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), BackgroundFetchRegistrationObserver_Internal.MANAGER, messageWithHeader, receiver);








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class BackgroundFetchRegistrationObserverOnProgressParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long uploadTotal;
        public long uploaded;
        public long downloadTotal;
        public long downloaded;
        public int result;
        public int failureReason;

        private BackgroundFetchRegistrationObserverOnProgressParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationObserverOnProgressParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationObserverOnProgressParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationObserverOnProgressParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationObserverOnProgressParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationObserverOnProgressParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationObserverOnProgressParams(elementsOrVersion);
                    {
                        
                    result.uploadTotal = decoder0.readLong(8);
                    }
                    {
                        
                    result.uploaded = decoder0.readLong(16);
                    }
                    {
                        
                    result.downloadTotal = decoder0.readLong(24);
                    }
                    {
                        
                    result.downloaded = decoder0.readLong(32);
                    }
                    {
                        
                    result.result = decoder0.readInt(40);
                        BackgroundFetchResult.validate(result.result);
                    }
                    {
                        
                    result.failureReason = decoder0.readInt(44);
                        BackgroundFetchFailureReason.validate(result.failureReason);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.uploadTotal, 8);
            
            encoder0.encode(this.uploaded, 16);
            
            encoder0.encode(this.downloadTotal, 24);
            
            encoder0.encode(this.downloaded, 32);
            
            encoder0.encode(this.result, 40);
            
            encoder0.encode(this.failureReason, 44);
        }
    }



    
    static final class BackgroundFetchRegistrationObserverOnRecordsUnavailableParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BackgroundFetchRegistrationObserverOnRecordsUnavailableParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationObserverOnRecordsUnavailableParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationObserverOnRecordsUnavailableParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationObserverOnRecordsUnavailableParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationObserverOnRecordsUnavailableParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationObserverOnRecordsUnavailableParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationObserverOnRecordsUnavailableParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BackgroundFetchRegistrationObserverOnRequestCompletedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public FetchApiRequest request;
        public FetchApiResponse response;

        private BackgroundFetchRegistrationObserverOnRequestCompletedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BackgroundFetchRegistrationObserverOnRequestCompletedParams() {
            this(0);
        }

        public static BackgroundFetchRegistrationObserverOnRequestCompletedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BackgroundFetchRegistrationObserverOnRequestCompletedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BackgroundFetchRegistrationObserverOnRequestCompletedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BackgroundFetchRegistrationObserverOnRequestCompletedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BackgroundFetchRegistrationObserverOnRequestCompletedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.request = FetchApiRequest.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.response = FetchApiResponse.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
            
            encoder0.encode(this.response, 16, true);
        }
    }



}
