
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/appcache/appcache.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class AppCacheFrontend_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<AppCacheFrontend, AppCacheFrontend.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<AppCacheFrontend, AppCacheFrontend.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.AppCacheFrontend";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, AppCacheFrontend impl) {
            return new Stub(core, impl);
        }

        @Override
        public AppCacheFrontend[] buildArray(int size) {
          return new AppCacheFrontend[size];
        }
    };


    private static final int CACHE_SELECTED_ORDINAL = 0;

    private static final int EVENT_RAISED_ORDINAL = 1;

    private static final int PROGRESS_EVENT_RAISED_ORDINAL = 2;

    private static final int ERROR_EVENT_RAISED_ORDINAL = 3;

    private static final int LOG_MESSAGE_ORDINAL = 4;

    private static final int SET_SUBRESOURCE_FACTORY_ORDINAL = 5;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements AppCacheFrontend.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void cacheSelected(
AppCacheInfo info) {

            AppCacheFrontendCacheSelectedParams _message = new AppCacheFrontendCacheSelectedParams();

            _message.info = info;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CACHE_SELECTED_ORDINAL)));

        }


        @Override
        public void eventRaised(
int eventId) {

            AppCacheFrontendEventRaisedParams _message = new AppCacheFrontendEventRaisedParams();

            _message.eventId = eventId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(EVENT_RAISED_ORDINAL)));

        }


        @Override
        public void progressEventRaised(
com.vccorp.url.mojom.Url url, int total, int complete) {

            AppCacheFrontendProgressEventRaisedParams _message = new AppCacheFrontendProgressEventRaisedParams();

            _message.url = url;

            _message.total = total;

            _message.complete = complete;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(PROGRESS_EVENT_RAISED_ORDINAL)));

        }


        @Override
        public void errorEventRaised(
AppCacheErrorDetails errorDetails) {

            AppCacheFrontendErrorEventRaisedParams _message = new AppCacheFrontendErrorEventRaisedParams();

            _message.errorDetails = errorDetails;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ERROR_EVENT_RAISED_ORDINAL)));

        }


        @Override
        public void logMessage(
int logLevel, String message) {

            AppCacheFrontendLogMessageParams _message = new AppCacheFrontendLogMessageParams();

            _message.logLevel = logLevel;

            _message.message = message;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(LOG_MESSAGE_ORDINAL)));

        }


        @Override
        public void setSubresourceFactory(
com.vccorp.network.mojom.UrlLoaderFactory urlLoaderFactory) {

            AppCacheFrontendSetSubresourceFactoryParams _message = new AppCacheFrontendSetSubresourceFactoryParams();

            _message.urlLoaderFactory = urlLoaderFactory;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_SUBRESOURCE_FACTORY_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<AppCacheFrontend> {

        Stub(com.vccorp.mojo.system.Core core, AppCacheFrontend impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                AppCacheFrontend_Internal.MANAGER, messageWithHeader);





                    case CACHE_SELECTED_ORDINAL: {

                        AppCacheFrontendCacheSelectedParams data =
                                AppCacheFrontendCacheSelectedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().cacheSelected(data.info);
                        return true;
                    }





                    case EVENT_RAISED_ORDINAL: {

                        AppCacheFrontendEventRaisedParams data =
                                AppCacheFrontendEventRaisedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().eventRaised(data.eventId);
                        return true;
                    }





                    case PROGRESS_EVENT_RAISED_ORDINAL: {

                        AppCacheFrontendProgressEventRaisedParams data =
                                AppCacheFrontendProgressEventRaisedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().progressEventRaised(data.url, data.total, data.complete);
                        return true;
                    }





                    case ERROR_EVENT_RAISED_ORDINAL: {

                        AppCacheFrontendErrorEventRaisedParams data =
                                AppCacheFrontendErrorEventRaisedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().errorEventRaised(data.errorDetails);
                        return true;
                    }





                    case LOG_MESSAGE_ORDINAL: {

                        AppCacheFrontendLogMessageParams data =
                                AppCacheFrontendLogMessageParams.deserialize(messageWithHeader.getPayload());

                        getImpl().logMessage(data.logLevel, data.message);
                        return true;
                    }





                    case SET_SUBRESOURCE_FACTORY_ORDINAL: {

                        AppCacheFrontendSetSubresourceFactoryParams data =
                                AppCacheFrontendSetSubresourceFactoryParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setSubresourceFactory(data.urlLoaderFactory);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), AppCacheFrontend_Internal.MANAGER, messageWithHeader, receiver);














                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class AppCacheFrontendCacheSelectedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AppCacheInfo info;

        private AppCacheFrontendCacheSelectedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AppCacheFrontendCacheSelectedParams() {
            this(0);
        }

        public static AppCacheFrontendCacheSelectedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AppCacheFrontendCacheSelectedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AppCacheFrontendCacheSelectedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AppCacheFrontendCacheSelectedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AppCacheFrontendCacheSelectedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.info = AppCacheInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.info, 8, false);
        }
    }



    
    static final class AppCacheFrontendEventRaisedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int eventId;

        private AppCacheFrontendEventRaisedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AppCacheFrontendEventRaisedParams() {
            this(0);
        }

        public static AppCacheFrontendEventRaisedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AppCacheFrontendEventRaisedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AppCacheFrontendEventRaisedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AppCacheFrontendEventRaisedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AppCacheFrontendEventRaisedParams(elementsOrVersion);
                    {
                        
                    result.eventId = decoder0.readInt(8);
                        AppCacheEventId.validate(result.eventId);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.eventId, 8);
        }
    }



    
    static final class AppCacheFrontendProgressEventRaisedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public int total;
        public int complete;

        private AppCacheFrontendProgressEventRaisedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AppCacheFrontendProgressEventRaisedParams() {
            this(0);
        }

        public static AppCacheFrontendProgressEventRaisedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AppCacheFrontendProgressEventRaisedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AppCacheFrontendProgressEventRaisedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AppCacheFrontendProgressEventRaisedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AppCacheFrontendProgressEventRaisedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.total = decoder0.readInt(16);
                    }
                    {
                        
                    result.complete = decoder0.readInt(20);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.total, 16);
            
            encoder0.encode(this.complete, 20);
        }
    }



    
    static final class AppCacheFrontendErrorEventRaisedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AppCacheErrorDetails errorDetails;

        private AppCacheFrontendErrorEventRaisedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AppCacheFrontendErrorEventRaisedParams() {
            this(0);
        }

        public static AppCacheFrontendErrorEventRaisedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AppCacheFrontendErrorEventRaisedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AppCacheFrontendErrorEventRaisedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AppCacheFrontendErrorEventRaisedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AppCacheFrontendErrorEventRaisedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.errorDetails = AppCacheErrorDetails.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.errorDetails, 8, false);
        }
    }



    
    static final class AppCacheFrontendLogMessageParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int logLevel;
        public String message;

        private AppCacheFrontendLogMessageParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AppCacheFrontendLogMessageParams() {
            this(0);
        }

        public static AppCacheFrontendLogMessageParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AppCacheFrontendLogMessageParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AppCacheFrontendLogMessageParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AppCacheFrontendLogMessageParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AppCacheFrontendLogMessageParams(elementsOrVersion);
                    {
                        
                    result.logLevel = decoder0.readInt(8);
                        ConsoleMessageLevel.validate(result.logLevel);
                    }
                    {
                        
                    result.message = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.logLevel, 8);
            
            encoder0.encode(this.message, 16, false);
        }
    }



    
    static final class AppCacheFrontendSetSubresourceFactoryParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.network.mojom.UrlLoaderFactory urlLoaderFactory;

        private AppCacheFrontendSetSubresourceFactoryParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AppCacheFrontendSetSubresourceFactoryParams() {
            this(0);
        }

        public static AppCacheFrontendSetSubresourceFactoryParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AppCacheFrontendSetSubresourceFactoryParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AppCacheFrontendSetSubresourceFactoryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AppCacheFrontendSetSubresourceFactoryParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AppCacheFrontendSetSubresourceFactoryParams(elementsOrVersion);
                    {
                        
                    result.urlLoaderFactory = decoder0.readServiceInterface(8, false, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.urlLoaderFactory, 8, false, com.vccorp.network.mojom.UrlLoaderFactory.MANAGER);
        }
    }



}
