
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/loader/navigation_predictor.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class AnchorElementMetrics extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public float ratioArea;
    public float ratioVisibleArea;
    public float ratioDistanceTopToVisibleTop;
    public float ratioDistanceCenterToVisibleTop;
    public float ratioDistanceRootTop;
    public float ratioDistanceRootBottom;
    public boolean isInIframe;
    public boolean containsImage;
    public boolean isSameHost;
    public boolean isUrlIncrementedByOne;
    public com.vccorp.url.mojom.Url sourceUrl;
    public com.vccorp.url.mojom.Url targetUrl;

    private AnchorElementMetrics(int version) {
        super(STRUCT_SIZE, version);
    }

    public AnchorElementMetrics() {
        this(0);
    }

    public static AnchorElementMetrics deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static AnchorElementMetrics deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static AnchorElementMetrics decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        AnchorElementMetrics result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new AnchorElementMetrics(elementsOrVersion);
                {
                    
                result.ratioArea = decoder0.readFloat(8);
                }
                {
                    
                result.ratioVisibleArea = decoder0.readFloat(12);
                }
                {
                    
                result.ratioDistanceTopToVisibleTop = decoder0.readFloat(16);
                }
                {
                    
                result.ratioDistanceCenterToVisibleTop = decoder0.readFloat(20);
                }
                {
                    
                result.ratioDistanceRootTop = decoder0.readFloat(24);
                }
                {
                    
                result.ratioDistanceRootBottom = decoder0.readFloat(28);
                }
                {
                    
                result.isInIframe = decoder0.readBoolean(32, 0);
                }
                {
                    
                result.containsImage = decoder0.readBoolean(32, 1);
                }
                {
                    
                result.isSameHost = decoder0.readBoolean(32, 2);
                }
                {
                    
                result.isUrlIncrementedByOne = decoder0.readBoolean(32, 3);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.sourceUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                result.targetUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.ratioArea, 8);
        
        encoder0.encode(this.ratioVisibleArea, 12);
        
        encoder0.encode(this.ratioDistanceTopToVisibleTop, 16);
        
        encoder0.encode(this.ratioDistanceCenterToVisibleTop, 20);
        
        encoder0.encode(this.ratioDistanceRootTop, 24);
        
        encoder0.encode(this.ratioDistanceRootBottom, 28);
        
        encoder0.encode(this.isInIframe, 32, 0);
        
        encoder0.encode(this.containsImage, 32, 1);
        
        encoder0.encode(this.isSameHost, 32, 2);
        
        encoder0.encode(this.isUrlIncrementedByOne, 32, 3);
        
        encoder0.encode(this.sourceUrl, 40, false);
        
        encoder0.encode(this.targetUrl, 48, false);
    }
}