package com.vcc.securedrm;

import android.util.Log;

import java.io.InputStream;

import javax.crypto.CipherInputStream;

public class DRMProcessing {

    private static final String LIBRARY_NAME = "DRMProcessing";

    private static boolean isLibLoaded = false;

    public static boolean loadLibrary() {
        try {
            System.loadLibrary(LIBRARY_NAME);
            isLibLoaded = true;
        } catch (Exception e) {
            isLibLoaded = false;
        } catch (Error e2) {
            isLibLoaded = false;
        }

        return isLibLoaded;
    }

    native static CipherInputStream opencrypt(String keyURI, byte[] encryptIv, InputStream dataSourceInputStream, String version);

    native static int decryptData(InputStream cipherInputStream, byte[] buffer, int offset, int readLength);

    static native byte[] convertByteData(byte[] buffer, int length);

//    /**
//     * @param encryptKey
//     * @param version
//     * @return
//     */
//    static native void retreiveKey(String encryptKey, byte[] encryptionKey, String version);

    public static InputStream opencrypt(String keyURI, byte[] encryptIv, InputStream inputStream) {
        CipherInputStream outputStream;
        if (isLibLoaded) {
            Log.d("=== ", "keyUri : "+keyURI);
            outputStream = opencrypt(keyURI, encryptIv, inputStream, BuildConfig.VERSION_NAME);
        }
        else
            outputStream = null;
        return outputStream;
    }

    public static int decrypt(InputStream cipherInputStream, byte[] buffer, int offset, int readLength) {
        int realLength = -1;
        if (isLibLoaded)
            realLength = decryptData(cipherInputStream, buffer, offset, readLength);
        else
            readLength = -1;
        return realLength;
    }

    public static void convertByteData(byte[] bufferInput, byte[] bufferOutput, int length) {
        if (isLibLoaded)
            bufferOutput = convertByteData(bufferInput, length);
        else
            bufferOutput = null;
    }

//    /**
//     * @param encryptKey
//     * @return
//     * @deprecated
//     */
//    public static void retreiveKey(String encryptKey, byte[] encryptionKey) {
//        retreiveKey(encryptKey, encryptionKey, BuildConfig.VERSION_NAME);
//    }

}
