/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@ThreadSafe
public abstract class AbstractCookieSpec
implements CookieSpec {
    private final Map<String, CookieAttributeHandler> attribHandlerMap;

    public AbstractCookieSpec() {
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(10);
    }

    protected AbstractCookieSpec(HashMap<String, CookieAttributeHandler> hashMap) {
        Asserts.notNull(hashMap, (String)"Attribute handler map");
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(hashMap);
    }

    protected AbstractCookieSpec(CommonCookieAttributeHandler ... commonCookieAttributeHandlerArray) {
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(commonCookieAttributeHandlerArray.length);
        for (CommonCookieAttributeHandler commonCookieAttributeHandler : commonCookieAttributeHandlerArray) {
            this.attribHandlerMap.put(commonCookieAttributeHandler.getAttributeName(), commonCookieAttributeHandler);
        }
    }

    @Deprecated
    public void registerAttribHandler(String string, CookieAttributeHandler cookieAttributeHandler) {
        Args.notNull((Object)string, (String)"Attribute name");
        Args.notNull((Object)cookieAttributeHandler, (String)"Attribute handler");
        this.attribHandlerMap.put(string, cookieAttributeHandler);
    }

    protected CookieAttributeHandler findAttribHandler(String string) {
        return this.attribHandlerMap.get(string);
    }

    protected CookieAttributeHandler getAttribHandler(String string) {
        CookieAttributeHandler cookieAttributeHandler = this.findAttribHandler(string);
        Asserts.check((cookieAttributeHandler != null ? 1 : 0) != 0, (String)("Handler not registered for " + string + " attribute"));
        return cookieAttributeHandler;
    }

    protected Collection<CookieAttributeHandler> getAttribHandlers() {
        return this.attribHandlerMap.values();
    }
}

