/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.layeredvideo;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.Layer;
import com.google.android.libraries.mediaframework.layeredvideo.LayerManager;
import com.google.android.libraries.mediaframework.layeredvideo.PlaybackControlLayer;
import com.google.android.libraries.mediaframework.layeredvideo.SubtitleLayer;
import com.google.android.libraries.mediaframework.layeredvideo.VideoSurfaceLayer;
import com.vcc.playerwrappersdk.controllers.PlayerController;
import java.util.ArrayList;

public class SimpleVideoPlayer {
    private final Context mContext;
    private final LayerManager layerManager;
    private final PlaybackControlLayer playbackControlLayer;
    private final SubtitleLayer subtitleLayer;
    private final VideoSurfaceLayer videoSurfaceLayer;
    private boolean autoplay;
    private PlayerController.OnPlayerCallback onPlayerCallback;

    public SimpleVideoPlayer(Context context, FrameLayout frameLayout, Video video, String string2, boolean bl, boolean bl2) {
        this(context, frameLayout, video, string2, bl, 0, bl2, null);
    }

    public SimpleVideoPlayer(Context context, FrameLayout frameLayout, Video video, String string2, boolean bl, int n, boolean bl2, PlaybackControlLayer.FullscreenCallback fullscreenCallback) {
        this.mContext = context;
        this.autoplay = bl;
        this.playbackControlLayer = new PlaybackControlLayer(string2, fullscreenCallback);
        this.subtitleLayer = new SubtitleLayer();
        this.videoSurfaceLayer = new VideoSurfaceLayer(bl);
        this.videoSurfaceLayer.setFixedContent(bl2);
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        arrayList.add(this.videoSurfaceLayer);
        arrayList.add(this.playbackControlLayer);
        arrayList.add(this.subtitleLayer);
        this.layerManager = new LayerManager(context, frameLayout, video, arrayList, bl2);
        this.layerManager.getExoplayerWrapper().setTextListener(this.subtitleLayer);
        if (n > 0) {
            this.layerManager.getExoplayerWrapper().seekTo(n);
        }
    }

    public void addActionButton(Drawable drawable2, String string2, View.OnClickListener onClickListener) {
        this.playbackControlLayer.addActionButton(this.mContext, drawable2, string2, onClickListener);
    }

    public void addPlaybackListener(ExoplayerWrapper.PlaybackListener playbackListener) {
        this.layerManager.getExoplayerWrapper().addListener(playbackListener);
    }

    public void disableSeeking() {
        this.playbackControlLayer.disableSeeking();
    }

    public void enableSeeking() {
        this.playbackControlLayer.enableSeeking();
    }

    public int getCurrentPosition() {
        return this.layerManager.getControl().getCurrentPosition();
    }

    public int getDuration() {
        return this.layerManager.getControl().getDuration();
    }

    public int getCurrentBuffering() {
        return this.playbackControlLayer.getCurrentBuffering();
    }

    public void hide() {
        this.videoSurfaceLayer.hide();
        this.playbackControlLayer.hide();
        this.subtitleLayer.setVisibility(8);
    }

    public void hideTopChrome() {
        this.playbackControlLayer.hideTopChrome();
    }

    public boolean isFullscreen() {
        return this.playbackControlLayer.isFullscreen();
    }

    public void setFullscreen(boolean bl) {
        this.playbackControlLayer.setFullscreen(bl);
    }

    public void moveSurfaceToBackground() {
        this.videoSurfaceLayer.moveSurfaceToBackground();
    }

    public void moveSurfaceToForeground() {
        this.videoSurfaceLayer.moveSurfaceToForeground();
    }

    public void pause() {
        this.videoSurfaceLayer.setAutoplay(false);
        this.layerManager.getControl().pause();
    }

    public void play() {
        this.videoSurfaceLayer.setAutoplay(this.autoplay);
        this.layerManager.getControl().start();
    }

    public void setChromeColor(int n) {
        this.playbackControlLayer.setChromeColor(n);
    }

    public void setFullscreenCallback(PlaybackControlLayer.FullscreenCallback fullscreenCallback) {
        this.playbackControlLayer.setFullscreenCallback(fullscreenCallback);
    }

    public void setPlayCallback(PlaybackControlLayer.PlayCallback playCallback) {
        this.playbackControlLayer.setPlayCallback(playCallback);
    }

    public void setLogoImage(Drawable drawable2) {
        this.playbackControlLayer.setLogoImageView(drawable2);
    }

    public void setPlaybackControlColor(int n) {
        this.playbackControlLayer.setControlColor(n);
    }

    public void setSeekbarColor(int n) {
        this.playbackControlLayer.setSeekbarColor(n);
    }

    public void setTextColor(int n) {
        this.playbackControlLayer.setTextColor(n);
    }

    public void setVideoTitle(String string2) {
        this.playbackControlLayer.setVideoTitle(string2);
    }

    public boolean shouldBePlaying() {
        return this.playbackControlLayer.shouldBePlaying();
    }

    public void show() {
        this.videoSurfaceLayer.show();
        this.playbackControlLayer.show();
        if (this.subtitleLayer != null && !this.subtitleLayer.isHideTitle()) {
            this.subtitleLayer.setVisibility(0);
        }
    }

    public void showTopChrome() {
        this.playbackControlLayer.showTopChrome();
    }

    public void release() {
        this.videoSurfaceLayer.release();
        this.layerManager.release();
    }

    public void hideController(boolean bl) {
        if (!bl || this.playbackControlLayer == null) {
            return;
        }
        this.playbackControlLayer.setShouldbeHide(true);
        this.playbackControlLayer.hide();
        this.subtitleLayer.setVisibility(8);
    }

    public void setHideTitle(boolean bl) {
        if (this.subtitleLayer == null) {
            return;
        }
        this.subtitleLayer.setHideTitle(bl);
        if (bl) {
            this.subtitleLayer.setVisibility(8);
        }
    }

    public void seekTo(int n) {
        this.layerManager.getExoplayerWrapper().seekTo(n);
    }

    public void setOnPlayerCallback(PlayerController.OnPlayerCallback onPlayerCallback) {
        this.onPlayerCallback = onPlayerCallback;
        if (this.playbackControlLayer != null) {
            this.playbackControlLayer.setOnPlayerCallback(onPlayerCallback);
        }
    }

    public PlayerController.OnPlayerCallback getOnPlayerCallback() {
        return this.onPlayerCallback;
    }

    public void toggleFullscreen() {
        if (this.playbackControlLayer != null) {
            this.playbackControlLayer.doToggleFullscreen();
        }
    }

    public boolean isPlaying() {
        return this.layerManager.getControl().isPlaying();
    }

    public boolean setMute(boolean bl) {
        return this.layerManager != null && this.layerManager.getExoplayerWrapper() != null && this.layerManager.getExoplayerWrapper().setMute(bl);
    }

    public float getCurrentVolume() {
        if (this.layerManager != null && this.layerManager.getExoplayerWrapper() != null) {
            return this.layerManager.getExoplayerWrapper().getCurrentVolume();
        }
        return 0.0f;
    }
}

